/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.image.metadata;

import com.drew.metadata.Directory;
import com.drew.metadata.MetadataException;
import com.drew.metadata.Tag;
import it.tidalwave.image.Rational;
import it.tidalwave.image.metadata.DirectoryAdapter;
import java.util.Date;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class DirectoryDrewAdapter
implements DirectoryAdapter {
    private Directory directory;

    public DirectoryDrewAdapter(Object directory) {
        this.directory = (Directory)directory;
    }

    public int[] getTags() {
        int[] result = new int[this.directory.getTagCount()];
        int j = 0;
        Iterator i = this.directory.getTagIterator();
        while (i.hasNext()) {
            Tag tag = (Tag)i.next();
            result[j++] = tag.getTagType();
        }
        return result;
    }

    public String[] getSubDirectoryNames() {
        return new String[0];
    }

    public DirectoryAdapter getSubDirectory(String name) {
        return null;
    }

    public Object getObject(int tag) throws NoSuchElementException {
        this.checkIfTagExists(tag);
        Rational[] value = this.directory.getObject(tag);
        if (value instanceof com.drew.lang.Rational) {
            value = new Rational((com.drew.lang.Rational)value);
        } else if (value instanceof com.drew.lang.Rational[]) {
            value = this.convertRationalArray((com.drew.lang.Rational[])value);
        }
        return value;
    }

    public String getTagName(int tag) {
        this.checkIfTagExists(tag);
        return this.directory.getTagName(tag);
    }

    public boolean containsTag(int tag) {
        return this.directory != null ? this.directory.containsTag(tag) : false;
    }

    public int getInteger(int tag) throws NoSuchElementException {
        this.checkIfTagExists(tag);
        try {
            return this.directory.getInt(tag);
        }
        catch (MetadataException e) {
            throw new NoSuchElementException("" + tag + ": " + (Object)((Object)e));
        }
    }

    public int getShort(int tag) throws NoSuchElementException {
        this.checkIfTagExists(tag);
        try {
            return this.directory.getInt(tag);
        }
        catch (MetadataException e) {
            throw new NoSuchElementException("" + tag + ": " + (Object)((Object)e));
        }
    }

    public short[] getShortArray(int tag) throws NoSuchElementException {
        this.checkIfTagExists(tag);
        try {
            int[] t = this.directory.getIntArray(tag);
            short[] s = new short[t.length];
            for (int i = 0; i < s.length; ++i) {
                s[i] = (short)t[i];
            }
            return s;
        }
        catch (MetadataException e) {
            throw new NoSuchElementException("" + tag + ": " + (Object)((Object)e));
        }
    }

    public String[] getStringArray(int tag) throws NoSuchElementException {
        this.checkIfTagExists(tag);
        try {
            return this.directory.getStringArray(tag);
        }
        catch (MetadataException e) {
            throw new NoSuchElementException("" + tag + ": " + (Object)((Object)e));
        }
    }

    public int[] getIntegerArray(int tag) throws NoSuchElementException {
        this.checkIfTagExists(tag);
        try {
            return this.directory.getIntArray(tag);
        }
        catch (MetadataException e) {
            throw new NoSuchElementException("" + tag + ": " + (Object)((Object)e));
        }
    }

    public int getByte(int tag) throws NoSuchElementException {
        this.checkIfTagExists(tag);
        try {
            return this.directory.getInt(tag);
        }
        catch (MetadataException e) {
            throw new NoSuchElementException("" + tag + ": " + (Object)((Object)e));
        }
    }

    public byte[] getByteArray(int tag) throws NoSuchElementException {
        this.checkIfTagExists(tag);
        try {
            return this.directory.getByteArray(tag);
        }
        catch (MetadataException e) {
            throw new NoSuchElementException("" + tag + ": " + (Object)((Object)e));
        }
    }

    public double getDouble(int tag) throws NoSuchElementException {
        this.checkIfTagExists(tag);
        try {
            return this.directory.getDouble(tag);
        }
        catch (MetadataException e) {
            throw new NoSuchElementException("" + tag + ": " + (Object)((Object)e));
        }
    }

    public double[] getDoubleArray(int tag) throws NoSuchElementException {
        this.checkIfTagExists(tag);
        throw new RuntimeException("Not implemented");
    }

    public float getFloat(int tag) throws NoSuchElementException {
        this.checkIfTagExists(tag);
        try {
            return this.directory.getFloat(tag);
        }
        catch (MetadataException e) {
            throw new NoSuchElementException("" + tag + ": " + (Object)((Object)e));
        }
    }

    public long getLong(int tag) throws NoSuchElementException {
        this.checkIfTagExists(tag);
        try {
            return this.directory.getLong(tag);
        }
        catch (MetadataException e) {
            throw new NoSuchElementException("" + tag + ": " + (Object)((Object)e));
        }
    }

    public boolean getBoolean(int tag) throws NoSuchElementException {
        this.checkIfTagExists(tag);
        try {
            return this.directory.getBoolean(tag);
        }
        catch (MetadataException e) {
            throw new NoSuchElementException("" + tag + ": " + (Object)((Object)e));
        }
    }

    public Date getDate(int tag) throws NoSuchElementException {
        this.checkIfTagExists(tag);
        try {
            return this.directory.getDate(tag);
        }
        catch (MetadataException e) {
            throw new NoSuchElementException("" + tag + ": " + (Object)((Object)e));
        }
    }

    public Rational getRational(int tag) throws NoSuchElementException {
        this.checkIfTagExists(tag);
        try {
            return new Rational(this.directory.getRational(tag));
        }
        catch (MetadataException e) {
            throw new NoSuchElementException("" + tag + ": " + (Object)((Object)e));
        }
    }

    public Rational[] getRationalArray(int tag) throws NoSuchElementException {
        this.checkIfTagExists(tag);
        try {
            return this.convertRationalArray(this.directory.getRationalArray(tag));
        }
        catch (MetadataException e) {
            throw new NoSuchElementException("" + tag + ": " + (Object)((Object)e));
        }
    }

    public String getString(int tag) throws NoSuchElementException {
        this.checkIfTagExists(tag);
        return this.directory.getString(tag);
    }

    private void checkIfTagExists(int tag) throws NoSuchElementException {
        if (!this.containsTag(tag)) {
            throw new NoSuchElementException("" + tag);
        }
    }

    private Rational[] convertRationalArray(com.drew.lang.Rational[] temp) {
        Rational[] r = new Rational[temp.length];
        for (int i = 0; i < r.length; ++i) {
            r[i] = new Rational(temp[i]);
        }
        return r;
    }
}

