/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.image.java2d;

import it.tidalwave.image.Quality;
import it.tidalwave.image.java2d.Java2DUtils;
import it.tidalwave.image.op.OperationImplementation;
import it.tidalwave.image.op.PaintOp;
import it.tidalwave.image.render.PreviewSettings;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.ImageObserver;
import java.awt.image.LookupOp;
import java.awt.image.LookupTable;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PaintJ2DOp
extends OperationImplementation<PaintOp, BufferedImage> {
    private static final String CLASS = PaintJ2DOp.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);

    @Override
    protected BufferedImage execute(PaintOp operation, BufferedImage bufferedImage) {
        int x = operation.getX();
        int y = operation.getY();
        int w = operation.getW();
        int h = operation.getH();
        Graphics2D g2 = operation.getGraphics2D();
        PreviewSettings previewSettings = operation.getPreviewSettings();
        ImageObserver imageObserver = operation.getImageObserver();
        Quality quality = operation.getQuality();
        logger.fine("execute(" + x + ", " + y + ", " + w + ", " + h + ", " + (Object)((Object)quality) + ")");
        if (w != 0) {
            Object saveRenderingHints = g2.getRenderingHint(RenderingHints.KEY_INTERPOLATION);
            Object interpolation = Java2DUtils.findRenderingHintsInterpolation(quality);
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, interpolation);
            g2.drawImage(this.applyPreviewSettings(bufferedImage, previewSettings), x, y, w, h, imageObserver);
            if (saveRenderingHints != null) {
                g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, saveRenderingHints);
            }
        } else {
            g2.drawImage((Image)this.applyPreviewSettings(bufferedImage, previewSettings), x, y, imageObserver);
        }
        return bufferedImage;
    }

    private BufferedImage applyPreviewSettings(BufferedImage image, PreviewSettings previewSettings) {
        BufferedImage theImage = image;
        if (previewSettings != null) {
            int size = DataBuffer.getDataTypeSize(image.getSampleModel().getDataType());
            LookupTable lookupTable = null;
            switch (size) {
                case 8: 
                case 32: {
                    lookupTable = previewSettings.getLookupTable8bit();
                    break;
                }
                case 16: {
                    lookupTable = previewSettings.getLookupTable16bit();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("DataSize is " + size);
                }
            }
            if (lookupTable != null) {
                LookupOp lOp = new LookupOp(lookupTable, null);
                Java2DUtils.logImage(logger, "applyPreviewSettings: ", image);
                theImage = lOp.filter(image, null);
            }
        }
        return theImage;
    }
}

