/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.extxml.xml;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.Stack;
import net.jangaroo.extxml.json.Json;
import net.jangaroo.extxml.json.JsonArray;
import net.jangaroo.extxml.json.JsonObject;
import net.jangaroo.extxml.model.ComponentClass;
import net.jangaroo.extxml.model.ComponentSuite;
import net.jangaroo.extxml.xml.CharacterRecordingHandler;
import net.jangaroo.utils.log.Log;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class ExmlToJsonHandler
extends CharacterRecordingHandler {
    private Locator locator;
    private Json result;
    private String resultXtype;
    private final ComponentSuite componentSuite;
    private Set<String> imports = new LinkedHashSet<String>();
    private static String numberPattern = "-?([0-9]+\\.[0-9]*)|(\\.[0-9]+)|([0-9]+)([eE][+-]?[0-9]+)?";
    private NumberFormat nf = NumberFormat.getNumberInstance(Locale.US);
    private Stack<Json> objects = new Stack();
    private Stack<String> attributes = new Stack();
    private boolean expectObjects = true;

    public ExmlToJsonHandler(ComponentSuite componentSuite) {
        this.componentSuite = componentSuite;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void endDocument() throws SAXException {
        if (!this.objects.empty()) {
            throw new SAXParseException("Json object stack not empty at the end of the document.", this.locator);
        }
        if (!this.attributes.empty()) {
            throw new SAXParseException("Attribute stack not empty at the end of the document.", this.locator);
        }
        if (!this.expectObjects) {
            throw new SAXParseException("The parser is in the wrong state at the end of the document.", this.locator);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if ("http://net.jangaroo.com/extxml/0.1".equals(uri)) {
            if ("import".equals(localName)) {
                this.imports.add(atts.getValue("class"));
            } else if ("object".equals(localName) && this.expectObjects) {
                if (atts.getLength() == 0) {
                    this.startRecordingCharacters();
                } else {
                    this.addElementToJsonObject(this.createJsonObject(atts));
                }
            }
        } else {
            Json parentJson;
            JsonObject jsonObject = this.createJsonObject(atts);
            Json json = parentJson = this.objects.empty() ? null : this.objects.peek();
            if (this.expectObjects) {
                ComponentClass compClazz;
                jsonObject.setTypePropertyName("xtype");
                if (!this.attributes.isEmpty()) {
                    String attribute = this.attributes.peek();
                    if (attribute.equals("plugins")) {
                        jsonObject.setTypePropertyName("ptype");
                    } else if (attribute.equals("layout")) {
                        jsonObject.setTypePropertyName("type");
                    } else if (attribute.equals("action")) {
                        jsonObject.setTypePropertyName("atype");
                    }
                }
                if ((compClazz = this.componentSuite.getComponentClassByNamespaceAndLocalName(uri, localName)) != null) {
                    this.imports.add(compClazz.getFullClassName());
                    jsonObject.setType(compClazz.getXtype());
                } else {
                    Log.e((String)String.format("No component class for element name '%s' found in component suite '%s'!", localName, uri), (int)this.locator.getLineNumber(), (int)this.locator.getColumnNumber());
                    jsonObject.setType(localName);
                }
                this.addElementToJsonObject(jsonObject);
                this.addObjectToStack(jsonObject);
            } else {
                assert (parentJson != null);
                this.addAttributeToStack(localName);
                if (!jsonObject.isEmpty()) {
                    parentJson.set(localName, jsonObject);
                    this.addObjectToStack(jsonObject);
                }
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("http://net.jangaroo.com/extxml/0.1".equals(uri)) {
            String characters;
            if ("object".equals(localName) && (characters = this.popRecordedCharacters()) != null) {
                this.addElementToJsonObject("{" + characters.trim() + "}");
            }
        } else if (this.expectObjects) {
            String attr = this.attributes.pop();
            assert (localName.equals(attr));
            this.expectObjects = false;
        } else {
            Json json = this.removeObjectFromStack();
            if (!(json instanceof JsonObject) || ((JsonObject)json).getTypePropertyName() == null) {
                this.removeAttributeFromStack();
            }
            if (this.objects.empty()) {
                this.result = json;
                this.resultXtype = (String)((JsonObject)this.result).remove("xtype");
            }
        }
    }

    private JsonObject createJsonObject(Attributes atts) {
        JsonObject newJsonObject = new JsonObject();
        for (int i = 0; i < atts.getLength(); ++i) {
            Object typedValue;
            String attsValue = atts.getValue(i);
            if ("true".equals(attsValue) || "false".equals(attsValue)) {
                typedValue = Boolean.parseBoolean(attsValue);
            } else if (attsValue.matches(numberPattern)) {
                try {
                    typedValue = this.nf.parse(attsValue);
                }
                catch (ParseException e) {
                    typedValue = attsValue;
                }
            } else {
                typedValue = attsValue;
            }
            newJsonObject.set(atts.getLocalName(i), typedValue);
        }
        return newJsonObject;
    }

    private void addElementToJsonObject(Object element) {
        Json parentJson;
        Json json = parentJson = this.objects.empty() ? null : this.objects.peek();
        if (parentJson != null) {
            assert (!this.attributes.empty());
            String attr = this.attributes.peek();
            Object obj = parentJson.get(attr);
            if (obj == null) {
                parentJson.set(attr, element);
            } else if (!(obj instanceof JsonArray)) {
                JsonArray array = new JsonArray();
                array.push(obj);
                array.push(element);
                parentJson.set(attr, array);
            } else {
                ((JsonArray)obj).push(element);
            }
        }
    }

    private void addObjectToStack(Json jsonObject) {
        this.objects.push(jsonObject);
        this.expectObjects = false;
    }

    private void addAttributeToStack(String attribute) {
        this.attributes.push(attribute);
        this.expectObjects = true;
    }

    private Json removeObjectFromStack() {
        this.expectObjects = true;
        return this.objects.pop();
    }

    private void removeAttributeFromStack() {
        this.attributes.pop();
        this.expectObjects = false;
    }

    public List<String> getImports() {
        return new ArrayList<String>(this.imports);
    }

    public Json getJson() {
        return this.result;
    }

    public String getXtype() {
        return this.resultXtype;
    }
}

