/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.extxml.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.jangaroo.extxml.model.DescriptionHolder;

public final class ConfigAttribute
extends DescriptionHolder {
    private static final Set<String> SIMPLE_JS_TYPES = new HashSet<String>(Arrays.asList("Boolean", "Number", "Date", "String"));
    private static final Collection<String> SEQUENCE_JS_TYPES = new HashSet<String>(Arrays.asList("Array", "MixedCollection", "Mixed"));
    private String name;
    private Collection<String> jsTypes;
    private String xsType;

    public ConfigAttribute(String name, String jsType, String description) {
        super(description);
        this.name = name;
        this.jsTypes = new HashSet<String>(Arrays.asList(jsType.split("[^a-zA-Z0-9$_.]")));
        if (this.jsTypes.size() == 1) {
            this.xsType = this.jsTypes.iterator().next();
            if (!SIMPLE_JS_TYPES.contains(this.xsType)) {
                this.xsType = null;
            }
        }
        if (this.xsType == null) {
            this.xsType = "String";
        }
    }

    public ConfigAttribute(String name, String jsType) {
        this(name, jsType, null);
    }

    public String getName() {
        return this.name;
    }

    public String getJsType() {
        return this.jsTypes.iterator().next();
    }

    public String getXsType() {
        return this.xsType;
    }

    public boolean isSimple() {
        for (String jsType : this.jsTypes) {
            if (SIMPLE_JS_TYPES.contains(jsType)) continue;
            return false;
        }
        return true;
    }

    public boolean isSequence() {
        for (String jsType : this.jsTypes) {
            if (!SEQUENCE_JS_TYPES.contains(jsType)) continue;
            return true;
        }
        return false;
    }

    public boolean isObject() {
        for (String jsType : this.jsTypes) {
            if (SIMPLE_JS_TYPES.contains(jsType) || SEQUENCE_JS_TYPES.contains(jsType)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.name + " : " + this.jsTypes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigAttribute that = (ConfigAttribute)o;
        return !(this.name == null ? that.name != null : !this.name.equals(that.name));
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }
}

