/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.extxml.json;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.jangaroo.extxml.ComponentSuiteRegistry;
import net.jangaroo.extxml.json.Json;
import net.jangaroo.extxml.json.JsonArray;
import net.jangaroo.extxml.model.ComponentClass;

public class JsonObject
implements Json {
    private Map<String, Object> properties = new LinkedHashMap<String, Object>();
    private String typePropertyName;

    public String getTypePropertyName() {
        return this.typePropertyName;
    }

    public void setTypePropertyName(String typePropertyName) {
        this.typePropertyName = typePropertyName;
    }

    public String getType() {
        return (String)this.get(this.getTypePropertyName());
    }

    public void setType(String type) {
        this.set(this.getTypePropertyName(), type);
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int indentFactor) {
        return this.toString(indentFactor, 0);
    }

    public static String quote(String string) {
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        char c = '\u0000';
        int len = string.length();
        StringBuilder sb = new StringBuilder(len + 4);
        sb.append('\"');
        block9: for (int i = 0; i < len; ++i) {
            char b = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    continue block9;
                }
                case '/': {
                    if (b == '<') {
                        sb.append('\\');
                    }
                    sb.append(c);
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        String t = "000" + Integer.toHexString(c);
                        sb.append("\\u").append(t.substring(t.length() - 4));
                        continue block9;
                    }
                    sb.append(c);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }

    static String valueToString(String key, Object value, int indentFactor, int indent) {
        if (value == null) {
            return "null";
        }
        if (value instanceof Number || value instanceof Boolean) {
            return value.toString();
        }
        if (value instanceof JsonObject) {
            ComponentClass actionClazz;
            String atype;
            JsonObject actionCfg;
            ComponentClass compClazz;
            JsonObject jsonObject = (JsonObject)value;
            String xtype = (String)jsonObject.get("xtype");
            if (xtype != null && (compClazz = ComponentSuiteRegistry.getInstance().findComponentClassByXtype(xtype)) != null && (actionCfg = (JsonObject)jsonObject.get("action")) != null && (atype = (String)actionCfg.get("atype")) != null && (actionClazz = ComponentSuiteRegistry.getInstance().findComponentClassByXtype(atype)) != null) {
                actionCfg.remove("atype");
                for (Map.Entry<String, Object> cfgProp : jsonObject.properties.entrySet()) {
                    String cfg = cfgProp.getKey();
                    if ("xtype".equals(cfg) || "action".equals(cfg)) continue;
                    actionCfg.set(cfg, cfgProp.getValue());
                }
                return String.format("new %s(new %s(%s))", compClazz.getFullClassName(), actionClazz.getFullClassName(), JsonObject.valueToString("action", actionCfg, indentFactor, indent));
            }
            return jsonObject.toString(indentFactor, indent);
        }
        if (value instanceof JsonArray) {
            return ((JsonArray)value).toString(indentFactor, indent);
        }
        if ("xtype".equals(key) || "ptype".equals(key) || "type".equals(key)) {
            ComponentClass compClazz;
            String xtype = (String)value;
            if ("type".equals(key) && xtype.endsWith("layout")) {
                xtype = xtype.substring(0, xtype.length() - "layout".length());
            }
            if ((compClazz = ComponentSuiteRegistry.getInstance().findComponentClassByXtype(xtype)) != null && !compClazz.getFullClassName().startsWith("ext.")) {
                return compClazz.getFullClassName() + "." + key;
            }
            return "\"" + xtype + "\"";
        }
        if (((String)value).startsWith("{") && ((String)value).endsWith("}")) {
            return ((String)value).substring(1, ((String)value).lastIndexOf("}"));
        }
        return JsonObject.quote(value.toString());
    }

    @Override
    public String toString(int indentFactor, int indent) {
        int n = this.properties.size();
        if (n == 0) {
            return "{}";
        }
        Iterator<String> keys = this.properties.keySet().iterator();
        StringBuffer sb = new StringBuffer("{");
        int newindent = indent + indentFactor;
        if (n == 1) {
            String key = keys.next();
            sb.append(key);
            sb.append(": ");
            sb.append(JsonObject.valueToString(key, this.properties.get(key), indentFactor, indent));
        } else {
            int j;
            while (keys.hasNext()) {
                String key = keys.next();
                if (sb.length() > 1) {
                    sb.append(",\n");
                } else {
                    sb.append('\n');
                }
                for (j = 0; j < newindent; ++j) {
                    sb.append(' ');
                }
                sb.append(key);
                sb.append(": ");
                sb.append(JsonObject.valueToString(key, this.properties.get(key), indentFactor, newindent));
            }
            if (sb.length() > 1) {
                sb.append('\n');
                for (j = 0; j < indent; ++j) {
                    sb.append(' ');
                }
            }
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public Object get(String property) {
        return this.properties.get(property);
    }

    @Override
    public void set(String property, Object value) {
        this.properties.put(property, value);
    }

    public Object remove(String property) {
        return this.properties.remove(property);
    }
}

