/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.extxml;

import java.util.LinkedHashMap;
import java.util.Map;
import net.jangaroo.extxml.model.ComponentClass;
import net.jangaroo.extxml.model.ComponentSuite;
import net.jangaroo.utils.log.Log;

public final class ComponentSuiteRegistry {
    private static final ComponentSuiteRegistry INSTANCE = new ComponentSuiteRegistry();
    private final Map<String, ComponentSuite> componentSuitesByNamespaceUri = new LinkedHashMap<String, ComponentSuite>(10);

    private ComponentSuiteRegistry() {
    }

    public static ComponentSuiteRegistry getInstance() {
        return INSTANCE;
    }

    public void add(ComponentSuite componentSuite) {
        this.componentSuitesByNamespaceUri.put(componentSuite.getNamespace(), componentSuite);
    }

    public ComponentSuite getComponentSuite(String namespaceUri) {
        ComponentSuite componentSuite = this.componentSuitesByNamespaceUri.get(namespaceUri);
        if (componentSuite == null) {
            Log.i((String)("Component suite for namespace URI " + namespaceUri + " not found in registry."));
        }
        return componentSuite;
    }

    public ComponentClass getComponentClass(String namespaceUri, String localName) {
        ComponentSuite componentSuite = ComponentSuiteRegistry.getInstance().getComponentSuite(namespaceUri);
        return componentSuite != null ? componentSuite.getComponentClassByLocalName(localName) : null;
    }

    public ComponentClass findComponentClassByXtype(String xtype) {
        for (ComponentSuite suite : this.componentSuitesByNamespaceUri.values()) {
            ComponentClass componentClass = suite.getComponentClassByXtype(xtype);
            if (componentClass == null) continue;
            return componentClass;
        }
        return null;
    }

    public ComponentClass findComponentClassByFullClassName(String fullComponentClassName) {
        for (ComponentSuite suite : this.componentSuitesByNamespaceUri.values()) {
            ComponentClass componentClass = suite.getComponentClassByFullClassName(fullComponentClassName);
            if (componentClass == null) continue;
            return componentClass;
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (ComponentSuite suite : this.componentSuitesByNamespaceUri.values()) {
            sb.append(suite.getNamespace()).append(", ");
        }
        return sb.toString();
    }

    public void reset() {
        this.componentSuitesByNamespaceUri.clear();
    }
}

