/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.exml.exmlconverter;

import java.io.File;
import java.util.Iterator;
import java.util.Properties;
import net.jangaroo.exml.exmlconverter.FileConverter;
import net.jangaroo.exml.exmlconverter.ParseException;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExmlConverterTool {
    private final Logger log = LoggerFactory.getLogger(ExmlConverterTool.class);
    private String encoding;
    private boolean anyErrors = false;
    private File directory;
    private Properties mappings;

    public ExmlConverterTool(String encoding, File directory, Properties mappings) {
        this.encoding = encoding;
        this.directory = directory;
        this.mappings = mappings;
    }

    public boolean convertAll() {
        Iterator<File> i = FileUtils.iterateFiles(this.directory, new String[]{"exml"}, true);
        while (i.hasNext()) {
            this.convert(i.next());
        }
        return !this.anyErrors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void convert(File file) {
        this.log.info("Processing " + file + "...");
        File tempFile = null;
        try {
            tempFile = File.createTempFile(file.getName() + ".", ".temp", file.getParentFile());
            File bakFile = new File(file.getPath() + ".bak");
            new FileConverter(file, tempFile, this.encoding, this.mappings).execute();
            if (this.moveFilesAfterConversion(file, tempFile, bakFile)) {
                this.anyErrors = true;
                FileUtils.deleteQuietly(tempFile);
                return;
            }
            FileUtils.deleteQuietly(tempFile);
        }
        catch (ParseException e) {
            this.log.error("... failed due to parse error: " + e.getMessage());
            this.anyErrors = true;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            FileUtils.deleteQuietly(tempFile);
            return;
            catch (Exception e2) {
                this.log.error("... failed due to internal error!", e2);
                this.anyErrors = true;
                return;
            }
        }
        finally {
            FileUtils.deleteQuietly(tempFile);
        }
        this.log.info("... done.");
        return;
    }

    private boolean moveFilesAfterConversion(File file, File tempFile, File bakFile) {
        FileUtils.deleteQuietly(bakFile);
        if (!file.renameTo(bakFile)) {
            this.log.error("... failed! Could not create backup file " + bakFile + ".");
            return true;
        }
        if (!tempFile.renameTo(file)) {
            this.log.error("... failed! Could not create updated file " + file + ".");
            if (!bakFile.renameTo(file)) {
                this.log.error("(And could not create restore backup file " + bakFile + " to " + file + ".");
            }
            return true;
        }
        return false;
    }
}

