/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.exml.exmlconverter;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.jangaroo.exml.exmlconverter.ParseException;
import net.jangaroo.utils.CompilerUtils;
import org.apache.commons.io.IOUtils;

public abstract class Converter {
    private static final Map<String, String> CLASS_TO_CLASS = Converter.readProperties("class.properties");
    private static final int NOTHING = -1;
    private BufferedReader reader;
    private int lookAhead = -1;
    private BufferedWriter writer;
    private Properties mappings;

    private static HashMap<String, String> readProperties(String resourceName) {
        Properties properties = new Properties();
        InputStream resourceAsStream = null;
        try {
            resourceAsStream = Converter.class.getResourceAsStream(resourceName);
            properties.load(resourceAsStream);
        }
        catch (IOException e) {
            throw new IllegalStateException(resourceName + " must be packaged with the Converter class");
        }
        finally {
            if (resourceAsStream != null) {
                try {
                    resourceAsStream.close();
                }
                catch (IOException e) {}
            }
        }
        return new HashMap<Object, Object>(properties);
    }

    public Converter(Properties mappings) {
        this.mappings = mappings;
    }

    protected abstract Writer createWriter() throws UnsupportedEncodingException, FileNotFoundException;

    protected abstract Reader createReader() throws UnsupportedEncodingException, FileNotFoundException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws IOException, ParseException {
        this.reader = new BufferedReader(this.createReader());
        this.writer = new BufferedWriter(this.createWriter());
        try {
            this.copyStream();
        }
        finally {
            IOUtils.closeQuietly(this.reader);
            IOUtils.closeQuietly(this.writer);
        }
    }

    private String translateElementName(String qName) {
        int colonPos = qName.indexOf(58);
        String namespace = qName.substring(0, colonPos + 1);
        String localName = qName.substring(colonPos + 1);
        String translated = this.translateLocalName(localName);
        return namespace + translated;
    }

    private String translateLocalName(String localName) {
        String translated = CLASS_TO_CLASS.get(localName);
        if (translated != null) {
            return translated;
        }
        return CompilerUtils.uncapitalize(localName);
    }

    protected int read() throws IOException {
        if (this.lookAhead != -1) {
            int result = this.lookAhead;
            this.lookAhead = -1;
            return result;
        }
        return this.reader.read();
    }

    private void unread(char c) {
        if (this.lookAhead != -1) {
            throw new IllegalStateException("multiple unread characters are not supported");
        }
        this.lookAhead = c;
    }

    protected void write(char c) throws IOException {
        this.writer.write(c);
    }

    protected void write(String s) throws IOException {
        this.writer.write(s);
    }

    private void copyForced(char expected) throws IOException, ParseException {
        int read = this.read();
        if (read == -1) {
            throw new ParseException("The file ended while expecting a '" + expected + "' character.");
        }
        char c = (char)read;
        if (c != expected) {
            throw new ParseException("Expected character '" + expected + "', but found character '" + c + "'.");
        }
        this.write(c);
    }

    private void copyForced(String expected) throws IOException, ParseException {
        for (int i = 0; i < expected.length(); ++i) {
            this.copyForced(expected.charAt(i));
        }
    }

    private void copyAny(String expected) throws IOException, ParseException {
        int read;
        while ((read = this.read()) != -1) {
            char c = (char)read;
            if (!expected.contains(String.valueOf(c))) {
                this.unread(c);
                return;
            }
            this.write(c);
        }
        return;
    }

    private void copyUntil(String expected, String messageOnEof) throws IOException, ParseException {
        int found = 0;
        while (true) {
            int read;
            if ((read = this.read()) == -1) {
                throw new ParseException(messageOnEof);
            }
            char c = (char)read;
            this.write(c);
            if (c == expected.charAt(found)) {
                if (++found != expected.length()) continue;
                return;
            }
            found = 0;
        }
    }

    protected void copyStream() throws IOException, ParseException {
        int read;
        while ((read = this.read()) != -1) {
            char c = (char)read;
            this.write(c);
            switch (c) {
                case '&': {
                    this.copyEntity();
                    break;
                }
                case '<': {
                    this.copyAngleBracketThingy();
                }
            }
        }
        return;
    }

    private void copyEntity() throws ParseException, IOException {
        char c;
        do {
            int read;
            if ((read = this.read()) == -1) {
                throw new ParseException("The file ended while parsing an entity.");
            }
            c = (char)read;
            this.write(c);
        } while (c != ';');
    }

    private void copyAngleBracketThingy() throws IOException, ParseException {
        int read = this.read();
        if (read == -1) {
            throw new ParseException("The file ended while parsing an element.");
        }
        char c = (char)read;
        switch (c) {
            case '!': {
                this.write(c);
                this.copyCommentOrCDATA();
                break;
            }
            case '?': {
                this.write(c);
                this.copyProcessingInstruction();
                break;
            }
            case '/': {
                this.write(c);
                this.copyClosingTag();
                break;
            }
            default: {
                this.unread(c);
                this.copyOpeningTag();
            }
        }
    }

    private void copyOpeningTag() throws IOException, ParseException {
        String elementName = this.parseElementName();
        this.writer.write(this.translateElementName(elementName));
        block4: while (true) {
            int read;
            if ((read = this.read()) == -1) {
                throw new ParseException("The file ended while parsing an opening tag.");
            }
            char c = (char)read;
            switch (c) {
                case '>': {
                    this.write(c);
                    return;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case '/': {
                    this.write(c);
                    continue block4;
                }
            }
            this.unread(c);
            this.copyAttribute();
        }
    }

    private void copyAttribute() throws IOException, ParseException {
        this.copyUntil("=", "The file ended while seeking to the equal sign of an attribute.");
        this.copyAny(" \t\r\f");
        int read = this.read();
        if (read == -1) {
            throw new ParseException("The file ended while expecting a quotation mark of an attribute value.");
        }
        char c = (char)read;
        if (c != '\"' && c != '\'') {
            throw new ParseException("A quotation mark was expected, but the character '" + c + "' was found.");
        }
        String attributeValue = this.readAttributeValue(c);
        this.write(c);
        this.write(this.convertAttributeValue(attributeValue));
        this.write(c);
    }

    private String convertAttributeValue(String attributeValue) {
        if ("http://net.jangaroo.com/extxml/0.1".equals(attributeValue)) {
            return "http://www.jangaroo.net/exml/0.8";
        }
        if ("http://extjs.com/ext3".equals(attributeValue)) {
            return "exml:ext.config";
        }
        if (this.mappings.containsKey(attributeValue)) {
            return "exml:" + this.mappings.getProperty(attributeValue);
        }
        return attributeValue;
    }

    private String readAttributeValue(char delimiter) throws IOException, ParseException {
        StringBuilder builder = new StringBuilder();
        while (true) {
            int read;
            if ((read = this.read()) == -1) {
                throw new ParseException("The file ended while parsing an attribute value.");
            }
            char c = (char)read;
            if (c == delimiter) break;
            builder.append(c);
        }
        return builder.toString();
    }

    private void copyClosingTag() throws IOException, ParseException {
        String elementName = this.parseElementName();
        this.writer.write(this.translateElementName(elementName));
        this.copyUntil(">", "The file ended while parsing a closing tag.");
    }

    private String parseElementName() throws IOException, ParseException {
        char c;
        StringBuilder builder = new StringBuilder();
        while (true) {
            int read;
            if ((read = this.read()) == -1) {
                throw new ParseException("The file ended while parsing a tag name.");
            }
            c = (char)read;
            if (!Character.isLetterOrDigit(c) && c != ':' && c != '_') break;
            builder.append(c);
        }
        this.unread(c);
        return builder.toString();
    }

    private void copyCommentOrCDATA() throws IOException, ParseException {
        int read = this.read();
        if (read == -1) {
            throw new ParseException("The file ended while parsing a comment or CDATA section.");
        }
        char c = (char)read;
        this.write(c);
        switch (c) {
            case '-': {
                this.copyComment();
                break;
            }
            case '[': {
                this.copyCDATA();
                break;
            }
            default: {
                this.copyUntil(">", "A '<' character was not matched with a '>' character before the end of the file.");
            }
        }
    }

    private void copyComment() throws IOException, ParseException {
        this.copyForced('-');
        this.copyUntil("-->", "The file ended while parsing a comment.");
    }

    private void copyCDATA() throws IOException, ParseException {
        this.copyForced("CDATA[");
        this.copyUntil("]]>", "The file ended while parsing a CDATA section.");
    }

    private void copyProcessingInstruction() throws IOException, ParseException {
        this.copyUntil("?>", "The file ended while parsing a processing instruction.");
    }
}

