/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.exml.configconverter.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.Stack;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.jangaroo.exml.configconverter.ComponentSuiteRegistry;
import net.jangaroo.exml.configconverter.model.ComponentClass;
import net.jangaroo.exml.configconverter.model.ComponentSuite;
import net.jangaroo.exml.configconverter.model.ConfigAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XsdScanner {
    private static final String XML_SCHEMA_URL = "http://www.w3.org/2001/XMLSchema";
    private final Logger log = LoggerFactory.getLogger(XsdScanner.class);
    private ComponentSuite componentSuite;
    private XMLStreamReader parser = null;
    private Stack<ComponentClass> ccStack = new Stack();
    private ConfigAttribute currentAttr = null;
    private boolean isInsideComplexType = false;
    private boolean isInsideCfg = false;
    private ComponentSuiteRegistry componentSuiteRegistry;
    private static final String SCHEMA = "schema";
    private static final String COMPLEX_TYPE = "complexType";
    private static final String ELEMENT = "element";
    private static final String ATTRIBUTE = "attribute";
    private static final String EXTENSION = "extension";
    private static final String DOCUMENTATION = "documentation";

    public XsdScanner(ComponentSuiteRegistry componentSuiteRegistry) {
        this.componentSuiteRegistry = componentSuiteRegistry;
    }

    public ComponentSuite getComponentSuite() {
        return this.componentSuite;
    }

    private boolean isLocalName(String localName) {
        return localName.equals(this.parser.getLocalName());
    }

    private ComponentSuite createComponentSuite() {
        String targetNS = this.parser.getAttributeValue(null, "targetNamespace");
        String nsPrefix = this.parser.getNamespaceContext().getPrefix(targetNS);
        return new ComponentSuite(this.componentSuiteRegistry, targetNS, nsPrefix, null, null, null);
    }

    private ComponentClass createComponentClass() {
        String name = this.parser.getAttributeValue(null, "name");
        ComponentClass componentClass = new ComponentClass(null, name);
        this.ccStack.push(componentClass);
        return componentClass;
    }

    private void addXtypeToComponentClass() throws XMLStreamException {
        String typeName;
        String xtype = this.parser.getAttributeValue(null, "id");
        if (xtype == null) {
            xtype = this.parser.getAttributeValue(null, "name");
        }
        if ((typeName = this.afterColon(this.parser.getAttributeValue(null, "type"))).startsWith("ext.")) {
            xtype = xtype.toLowerCase();
        }
        ComponentClass componentClass = (ComponentClass)this.ccStack.lastElement();
        assert (typeName.equals(componentClass.getFullClassName()));
        componentClass.setXtype(xtype);
    }

    private String afterColon(String typeName) {
        return typeName.substring(typeName.indexOf(58) + 1);
    }

    private void addSupertypeToComponentClass() {
        String supertypeName = this.afterColon(this.parser.getAttributeValue(null, "base"));
        ComponentClass componentClass = (ComponentClass)this.ccStack.lastElement();
        componentClass.setSuperClassName(supertypeName);
    }

    private void addConfigElementAttribute() throws XMLStreamException {
        String name = this.parser.getAttributeValue(null, "name");
        ConfigAttribute attr = new ConfigAttribute(name, "Array");
        ((ComponentClass)this.ccStack.lastElement()).addCfg(attr);
        this.currentAttr = attr;
    }

    private void addConfigAttribute() throws XMLStreamException {
        String name = this.parser.getAttributeValue(null, "name");
        String type = this.parser.getAttributeValue(null, "type");
        ConfigAttribute attr = new ConfigAttribute(name, type);
        ((ComponentClass)this.ccStack.lastElement()).addCfg(attr);
        this.currentAttr = attr;
    }

    private void parseDocumentation() throws XMLStreamException {
        StringBuffer txt = new StringBuffer();
        while (this.parser.hasNext()) {
            this.parser.next();
            if (this.parser.hasText()) {
                txt.append(this.parser.getText());
                continue;
            }
            if (this.parser.isStartElement()) {
                txt.append("<").append(this.parser.getLocalName()).append(">");
                continue;
            }
            if (!this.parser.isEndElement()) continue;
            if (this.isLocalName(DOCUMENTATION)) break;
            txt.append("</").append(this.parser.getLocalName()).append(">");
        }
        if (this.currentAttr != null) {
            this.currentAttr.setDescription(txt.toString());
        } else {
            ((ComponentClass)this.ccStack.lastElement()).setDescription(txt.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentSuite scan(InputStream xsd) throws IOException {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        try {
            this.parser = factory.createXMLStreamReader(xsd);
            while (this.parser.hasNext()) {
                int event = this.parser.next();
                if (!XML_SCHEMA_URL.equals(this.parser.getNamespaceURI())) continue;
                this.dispatch(event);
            }
        }
        catch (XMLStreamException e) {
            this.log.error("Error while parsing XSD", e);
        }
        finally {
            try {
                if (this.parser != null) {
                    this.parser.close();
                }
            }
            catch (XMLStreamException e) {
                this.log.error("Error while parsing XSD", e);
            }
        }
        return this.componentSuite;
    }

    private void dispatch(int event) throws XMLStreamException {
        switch (event) {
            case 1: {
                if (this.isLocalName(SCHEMA)) {
                    this.componentSuite = this.createComponentSuite();
                    break;
                }
                if (!this.isInsideComplexType && this.isLocalName(COMPLEX_TYPE)) {
                    this.isInsideComplexType = true;
                    this.createComponentClass();
                    break;
                }
                if (this.isLocalName(ELEMENT)) {
                    if (this.isInsideComplexType) {
                        this.addConfigElementAttribute();
                        this.isInsideCfg = true;
                        break;
                    }
                    this.addXtypeToComponentClass();
                    break;
                }
                if (this.isInsideComplexType && !this.isInsideCfg && this.isLocalName(EXTENSION)) {
                    this.addSupertypeToComponentClass();
                    break;
                }
                if (this.isLocalName(ATTRIBUTE)) {
                    this.addConfigAttribute();
                    break;
                }
                if (!this.isLocalName(DOCUMENTATION)) break;
                this.parseDocumentation();
                break;
            }
            case 2: {
                if (this.isLocalName(SCHEMA)) {
                    assert (this.ccStack.isEmpty());
                    break;
                }
                if (this.isLocalName(COMPLEX_TYPE) && !this.isInsideCfg) {
                    this.isInsideComplexType = false;
                    break;
                }
                if (this.isLocalName(ELEMENT)) {
                    if (this.isInsideCfg) {
                        this.isInsideCfg = false;
                        this.currentAttr = null;
                        break;
                    }
                    ComponentClass componentClass = this.ccStack.pop();
                    this.componentSuite.addComponentClass(componentClass);
                    break;
                }
                if (!this.isLocalName(ATTRIBUTE)) break;
                this.currentAttr = null;
                break;
            }
            case 4: {
                break;
            }
        }
    }
}

