/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.exml.configconverter.xml;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import net.jangaroo.exml.configconverter.model.ComponentClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public final class ContentHandlerUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ContentHandlerUtils.class);

    private ContentHandlerUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean parseExmlWithHandler(ComponentClass cc, ContentHandler handler) {
        FileInputStream inputStream = null;
        try {
            XMLReader xr = XMLReaderFactory.createXMLReader();
            xr.setContentHandler(handler);
            inputStream = new FileInputStream(cc.getSrcFile());
            xr.parse(new InputSource(inputStream));
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException e) {
            LOG.error("Exception while parsing", e);
        }
        catch (IOException e) {
            LOG.error("Exception while parsing", e);
        }
        catch (SAXParseException e) {
            LOG.error(e.getMessage(), e.getLineNumber(), (Object)e.getColumnNumber());
        }
        catch (SAXException e) {
            LOG.error("Exception while parsing", e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {}
        }
        return false;
    }
}

