/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.exml.configconverter.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.jangaroo.exml.configconverter.model.ComponentSuite;
import net.jangaroo.exml.configconverter.model.ComponentType;
import net.jangaroo.exml.configconverter.model.ConfigAttribute;
import net.jangaroo.exml.configconverter.model.DescriptionHolder;

public final class ComponentClass
extends DescriptionHolder {
    private ComponentSuite suite;
    private File srcFile;
    private String xtype;
    private List<String> imports;
    private String fullClassName;
    private String superClassLocalName;
    private String superClassNamespaceUri;
    private String superClassName;
    private List<ConfigAttribute> cfgs = new ArrayList<ConfigAttribute>();
    private ComponentType type;

    public ComponentClass(String xtype, String fullClassName) {
        this.xtype = xtype;
        this.fullClassName = fullClassName;
        this.imports = new ArrayList<String>();
    }

    public ComponentClass(File srcFile) {
        this.srcFile = srcFile;
        this.imports = new ArrayList<String>();
    }

    public void setSuite(ComponentSuite suite) {
        this.suite = suite;
    }

    public ComponentSuite getSuite() {
        return this.suite;
    }

    public String getRelativeSrcFilePath() {
        return ComponentClass.relativeSrcFilePath(this.getSuite(), this.getSrcFile());
    }

    public static String relativeSrcFilePath(ComponentSuite suite, File srcFile) {
        if (srcFile != null && suite != null && suite.getRootDir() != null) {
            int rootDirPathLength = suite.getRootDir().getPath().length();
            return srcFile.getPath().substring(rootDirPathLength);
        }
        return null;
    }

    public File getSrcFile() {
        return this.srcFile;
    }

    public void setXtype(String xtype) {
        this.xtype = xtype;
    }

    public String getXtype() {
        return this.xtype;
    }

    public String getLastXtypeComponent() {
        int lastDot = this.xtype.lastIndexOf(46);
        return this.xtype.substring(lastDot + 1);
    }

    public String getElementName() {
        return this.xtype.substring(this.xtype.lastIndexOf(46) + 1);
    }

    public List<String> getImports() {
        return this.imports;
    }

    public void addImport(String className) {
        this.imports.add(className);
    }

    public void setImports(List<String> imports) {
        this.imports = imports;
    }

    public void setFullClassName(String fullClassName) {
        this.fullClassName = fullClassName;
    }

    public String getFullClassName() {
        return this.fullClassName;
    }

    public String getClassName() {
        return this.fullClassName.substring(this.fullClassName.lastIndexOf(46) + 1);
    }

    public String getPackageName() {
        int lastDotPos = this.fullClassName.lastIndexOf(46);
        return lastDotPos == -1 ? "" : this.fullClassName.substring(0, lastDotPos);
    }

    public String getXsType() {
        return this.suite.getPrefix() + this.fullClassName;
    }

    public String getSuperClassName() {
        return this.superClassName;
    }

    public ComponentClass getSuperClass() {
        return this.superClassName == null ? null : this.suite.findComponentClassByFullClassName(this.superClassName);
    }

    public void setSuperClassName(String superClassName) {
        this.superClassName = superClassName;
    }

    public Collection<ConfigAttribute> getCfgs() {
        return this.cfgs;
    }

    public Collection<ConfigAttribute> getDirectCfgs() {
        ComponentClass cc = this.getSuperClass();
        if (cc != null) {
            ArrayList<ConfigAttribute> directCfgs = new ArrayList<ConfigAttribute>(this.cfgs);
            do {
                directCfgs.removeAll(cc.getCfgs());
            } while ((cc = cc.getSuperClass()) != null);
            return directCfgs;
        }
        return this.cfgs;
    }

    public void addCfg(ConfigAttribute cfg) {
        this.cfgs.add(cfg);
    }

    public void setCfgs(List<ConfigAttribute> cfgs) {
        this.cfgs = cfgs;
    }

    public ComponentType getType() {
        return this.type;
    }

    public void setType(ComponentType type) {
        this.type = type;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder().append("class: ").append(this.fullClassName).append(" xtype: ").append(this.xtype);
        if (this.superClassName != null) {
            builder.append(" extends ").append(this.superClassName);
        }
        if (this.srcFile != null) {
            builder.append(" file ").append(this.getRelativeSrcFilePath());
        }
        for (ConfigAttribute cfg : this.cfgs) {
            builder.append(" ").append(cfg);
        }
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComponentClass that = (ComponentClass)o;
        if (!this.fullClassName.equals(that.fullClassName)) {
            return false;
        }
        if (this.superClassName != null ? !this.superClassName.equals(that.superClassName) : that.superClassName != null) {
            return false;
        }
        return this.xtype.equals(that.xtype);
    }

    public int hashCode() {
        int result = this.xtype.hashCode();
        result = 31 * result + this.fullClassName.hashCode();
        result = 31 * result + (this.superClassName != null ? this.superClassName.hashCode() : 0);
        return result;
    }

    public void setSuperClassLocalName(String superClassLocalName) {
        this.superClassLocalName = superClassLocalName;
    }

    public void setSuperClassNamespaceUri(String superClassNamespaceUri) {
        this.superClassNamespaceUri = superClassNamespaceUri;
    }

    public String getSuperClassLocalName() {
        return this.superClassLocalName;
    }

    public String getSuperClassNamespaceUri() {
        return this.superClassNamespaceUri;
    }
}

