/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.exml.configconverter.generation;

import freemarker.core.Environment;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Locale;
import net.jangaroo.exml.configconverter.generation.ConfigClassModel;
import net.jangaroo.exml.configconverter.model.ComponentClass;
import net.jangaroo.exml.configconverter.model.ComponentSuite;
import net.jangaroo.exml.configconverter.model.ComponentType;
import org.codehaus.plexus.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigClassGenerator {
    private final Logger log = LoggerFactory.getLogger(ConfigClassGenerator.class);
    private static final String outputCharset = "UTF-8";
    private ComponentSuite componentSuite;

    public ConfigClassGenerator(ComponentSuite componentSuite) {
        this.componentSuite = componentSuite;
    }

    public void generateJangarooClass(ComponentClass jooClass, String configClassName, Writer output) throws IOException, TemplateException {
        if (this.validateComponentClass(jooClass)) {
            Configuration cfg = new Configuration();
            cfg.setClassForTemplateLoading(ComponentClass.class, "/");
            cfg.setObjectWrapper(new DefaultObjectWrapper());
            Template template = cfg.getTemplate("/net/jangaroo/exml/templates/config_class.ftl");
            String type = this.computeType(jooClass);
            ConfigClassModel configClassModel = new ConfigClassModel(jooClass, this.componentSuite, configClassName, type);
            this.log.info("Generate config class '" + configClassModel.getComponentSuite().getConfigClassPackage() + "." + configClassModel.getClassName() + "' for component class '" + jooClass.getFullClassName() + "'");
            Environment env = template.createProcessingEnvironment(configClassModel, output);
            env.setOutputEncoding(outputCharset);
            env.process();
        }
    }

    private String computeType(ComponentClass jooClass) {
        String type = "xtype";
        for (ComponentClass currentClass = jooClass; currentClass != null; currentClass = currentClass.getSuperClass()) {
            if (currentClass.getFullClassName().equals("ext.Action")) {
                type = "";
                break;
            }
            if (!currentClass.getClassName().toLowerCase(Locale.ROOT).endsWith("plugin")) continue;
            type = "ptype";
            break;
        }
        return type;
    }

    private boolean validateComponentClass(ComponentClass jooClass) {
        boolean isValid = true;
        if (StringUtils.isEmpty(jooClass.getXtype())) {
            this.log.error(String.format("Xtype of component '%s' is undefined!", jooClass.getFullClassName()));
            isValid = false;
        }
        if (StringUtils.isEmpty(jooClass.getClassName())) {
            this.log.error(String.format("Class name of component '%s' is undefined!", jooClass.getFullClassName()));
            isValid = false;
        }
        for (String importStr : jooClass.getImports()) {
            if (!StringUtils.isEmpty(importStr)) continue;
            this.log.error(String.format("An empty import found. Something is wrong in your class %s", jooClass.getFullClassName()));
            isValid = false;
        }
        return isValid;
    }

    public void generateClasses() {
        for (ComponentClass cc : this.componentSuite.getComponentClassesByType(ComponentType.ActionScript)) {
            this.generateClass(cc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File generateClass(ComponentClass componentClass) {
        String configClassName;
        File configClassDir = new File(this.componentSuite.getAs3OutputDir(), this.componentSuite.getConfigClassPackage().replace('.', File.separatorChar));
        File outputFile = new File(configClassDir, (configClassName = StringUtils.uncapitalise(componentClass.getLastXtypeComponent())) + ".as");
        if (!outputFile.getParentFile().exists() && outputFile.getParentFile().mkdirs()) {
            this.log.debug("Folder '" + outputFile.getParentFile().getAbsolutePath() + "' created.");
        }
        Writer writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), outputCharset);
            this.generateJangarooClass(componentClass, configClassName, writer);
        }
        catch (IOException e) {
            this.log.error("Exception while creating class", e);
        }
        catch (TemplateException e) {
            this.log.error("Exception while creating class", e);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {}
        }
        return outputFile;
    }
}

