/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.exml.configconverter.file;

import java.io.File;
import java.io.IOException;
import net.jangaroo.exml.configconverter.file.ExmlComponentSrcFileScanner;
import net.jangaroo.exml.configconverter.file.ExtComponentSrcFileScanner;
import net.jangaroo.exml.configconverter.model.ComponentSuite;
import net.jangaroo.exml.configconverter.model.ComponentType;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;
import org.codehaus.plexus.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SrcFileScanner {
    private final Logger log = LoggerFactory.getLogger(SrcFileScanner.class);
    private ComponentSuite componentSuite;

    public SrcFileScanner(ComponentSuite componentSuite) {
        this.componentSuite = componentSuite;
    }

    public ComponentSuite getComponentSuite() {
        return this.componentSuite;
    }

    public void scan() throws IOException {
        this.scan(this.componentSuite.getRootDir());
        this.componentSuite.resolveSuperClasses();
    }

    private void scan(File dir) throws IOException {
        FileSet srcFiles = new FileSet();
        srcFiles.setDirectory(dir.getAbsolutePath());
        srcFiles.addInclude("**/*." + ComponentType.JavaScript.getExtension());
        srcFiles.addExclude("**/*-more." + ComponentType.JavaScript.getExtension());
        srcFiles.addInclude("**/*." + ComponentType.ActionScript.getExtension());
        srcFiles.addInclude("**/*." + ComponentType.EXML.getExtension());
        for (String srcFileRelativePath : new FileSetManager().getIncludedFiles(srcFiles)) {
            File srcFile = new File(dir, srcFileRelativePath);
            ComponentType type = ComponentType.from(FileUtils.extension(srcFile.getName()));
            if (ComponentType.EXML.equals((Object)type)) {
                ExmlComponentSrcFileScanner.scan(this.componentSuite, srcFile, type);
                continue;
            }
            ExtComponentSrcFileScanner.scan(this.componentSuite, srcFile, type);
        }
    }
}

