/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.exml.configconverter.file;

import java.io.File;
import java.io.IOException;
import java.util.List;
import net.jangaroo.exml.configconverter.model.ComponentClass;
import net.jangaroo.exml.configconverter.model.ComponentSuite;
import net.jangaroo.exml.configconverter.model.ComponentType;
import net.jangaroo.exml.configconverter.model.ConfigAttribute;
import net.jangaroo.exml.configconverter.model.DescriptionHolder;
import net.jangaroo.exml.configconverter.util.FileScanner;
import net.jangaroo.exml.configconverter.util.Rule;
import net.jangaroo.exml.configconverter.util.TidyComment;
import org.codehaus.plexus.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExtComponentSrcFileScanner {
    private static final Logger LOG = LoggerFactory.getLogger(ExtComponentSrcFileScanner.class);
    private static final Rule<State> TYPE_RULE = new Rule<State>("@[apx]type\\s+([\\p{Alpha}$_.][\\p{Alnum}$_.]*)"){

        @Override
        public void matched(State state, List<String> groups) {
            if (state.insideComment) {
                state.setXtype(groups.get(0), state.cc.getFullClassName());
            }
        }
    };
    private static final Rule<State> CFG_RULE = new Rule<State>("@cfg\\s+[{]?([\\p{Alnum}$_./|]+)[}]?\\s+([\\p{Alnum}$_]+)(.*)$"){

        @Override
        public void matched(State state, List<String> groups) {
            if (state.insideComment) {
                state.addCfg(groups.size() == 3 ? groups.remove(0) : "*", groups.remove(0), groups.remove(0));
            }
        }
    };
    private static final Rule<State> COMMENT_START_RULE = new Rule<State>("^\\s*/\\*\\* ?(.*)$"){

        @Override
        public void matched(State state, List<String> groups) {
            if (!state.insideComment) {
                state.startComment(groups.get(0));
            }
        }
    };
    private static final Rule<State> COMMENT_RULE = new Rule<State>("^\\s*\\*? ?(.*)$"){

        @Override
        public void matched(State state, List<String> groups) {
            if (state.insideComment) {
                state.addComment(groups.get(0));
            }
        }
    };
    private static final Rule<State> COMMENT_END_RULE = new Rule<State>("\\*/"){

        @Override
        public void matched(State state, List<String> groups) {
            if (state.insideComment) {
                state.endComment();
            }
        }
    };
    private static final FileScanner<State> EXT_COMPONENT_AS_FILE_SCANNER = new FileScanner<State>().add(new Rule<State>("^\\s*package\\s+([\\p{Alnum}$_.]+)"){

        @Override
        public void matched(State state, List<String> groups) {
            if (!state.insideComment) {
                state.cc.setFullClassName(groups.get(0) + "." + state.cc.getClassName());
                state.setDescriptionHolder(state.cc);
            }
        }
    }).add(new Rule<State>("^\\s*import\\s+([\\p{Alnum}$_.]+);"){

        @Override
        public void matched(State state, List<String> groups) {
            if (!state.insideComment) {
                state.addImport(groups.get(0));
            }
        }
    }).add(new Rule<State>("\\bextends\\s+([\\p{Alnum}$_.]+)"){

        @Override
        public void matched(State state, List<String> groups) {
            if (!state.insideComment) {
                state.setExtends(groups.get(0));
            }
        }
    }).add(new Rule<State>("(?:public\\s+static|static\\s+public)\\s+const\\s+[apx]type\\s*:\\s*String\\s*=\\s*['\"]([^'\"]+)['\"]"){

        @Override
        public void matched(State state, List<String> groups) {
            if (!state.insideComment) {
                state.setXtype(groups.get(0), state.cc.getFullClassName());
            }
        }
    }).add(CFG_RULE).add(COMMENT_END_RULE).add(new Rule<State>("\\s@[a-z]"){

        @Override
        public void matched(State state, List<String> groups) {
            if (state.isInConfig()) {
                state.setDescriptionHolder(null);
            }
        }
    }).add(new Rule<State>("^?\\s*/\\*\\*?(.*)$"){

        @Override
        public void matched(State state, List<String> groups) {
            if (!state.insideComment) {
                state.startComment(groups.get(0));
            }
        }
    }).add(COMMENT_RULE);
    private static final FileScanner<State> EXT_COMPONENT_SRC_FILE_SCANNER = new FileScanner<State>().add(new Rule<State>("@class\\s+([\\p{Alnum}$_.]+)"){

        @Override
        public void matched(State state, List<String> groups) {
            if (state.insideComment) {
                state.addClass(groups.get(0));
            }
        }
    }).add(new Rule<State>("@extends\\s+([\\p{Alnum}$_.]+)"){

        @Override
        public void matched(State state, List<String> groups) {
            if (state.insideComment) {
                state.setExtends(groups.get(0));
            }
        }
    }).add(new Rule<State>("@constructor"){

        @Override
        public void matched(State state, List<String> groups) {
            if (state.insideComment) {
                state.setDescriptionHolder(null);
            }
        }
    }).add(new Rule<State>("\\bExt\\.reg\\('([\\p{Alnum}$_.]+)',\\s*([\\p{Alnum}$_.]+)\\);"){

        @Override
        public void matched(State state, List<String> groups) {
            if (!state.insideComment) {
                state.setXtype(groups.get(0), groups.get(1));
            }
        }
    }).add(new Rule<State>("\\bExt\\.Container\\.LAYOUTS\\['([\\p{Alnum}$_.]+)'\\]\\s*=\\s*([\\p{Alnum}$_.]+);"){

        @Override
        public void matched(State state, List<String> groups) {
            if (!state.insideComment) {
                state.setXtype(groups.get(0) + "layout", groups.get(1));
            }
        }
    }).add(new Rule<State>("\\bExt\\.Container\\.LAYOUTS\\.([\\p{Alnum}$_.]+)\\s*=\\s*([\\p{Alnum}$_.]+);"){

        @Override
        public void matched(State state, List<String> groups) {
            if (!state.insideComment) {
                state.setXtype(groups.get(0) + "layout", groups.get(1));
            }
        }
    }).add(TYPE_RULE).add(CFG_RULE).add(COMMENT_END_RULE).add(COMMENT_START_RULE).add(COMMENT_RULE);

    private ExtComponentSrcFileScanner() {
    }

    public static void scan(ComponentSuite componentSuite, File srcFile, ComponentType type) throws IOException {
        State state = new State(componentSuite, srcFile);
        if (ComponentType.ActionScript.equals((Object)type)) {
            String className = FileUtils.removeExtension(srcFile.getName());
            state.addClass(className);
            state.cc.setType(ComponentType.ActionScript);
            EXT_COMPONENT_AS_FILE_SCANNER.scan(srcFile, state);
        } else if (ComponentType.JavaScript.equals((Object)type)) {
            EXT_COMPONENT_SRC_FILE_SCANNER.scan(srcFile, state);
            if (state.cc != null) {
                state.cc.setType(ComponentType.JavaScript);
            }
        }
        state.end();
    }

    private static class State {
        private ComponentSuite componentSuite;
        private File srcFile;
        private ComponentClass cc;
        private boolean insideComment;
        private StringBuilder description = new StringBuilder();
        private DescriptionHolder descriptionHolder;

        State(ComponentSuite componentSuite, File srcFile) {
            this.componentSuite = componentSuite;
            this.srcFile = srcFile;
        }

        private void addClass(String className) {
            this.addIfHasXtype(this.cc);
            this.cc = new ComponentClass(this.srcFile);
            this.cc.setFullClassName(this.jsType2asType(className));
            this.setDescriptionHolder(this.cc);
        }

        private void addImport(String className) {
            this.cc.addImport(className);
        }

        private void setExtends(String superClassName) {
            if (this.isActionScript()) {
                String fullClassName = this.cc.getPackageName() + "." + superClassName;
                for (String imp : this.cc.getImports()) {
                    if (!imp.endsWith(superClassName)) continue;
                    fullClassName = imp;
                }
                this.cc.setSuperClassName(fullClassName);
                this.setDescriptionHolder(null);
            } else if (this.cc != null) {
                this.cc.setSuperClassName(this.jsType2asType(superClassName));
            }
        }

        public void setXtype(String xtype, String className) {
            if (this.cc != null && this.cc.getXtype() == null && this.jsType2asType(className).equals(this.cc.getFullClassName())) {
                this.cc.setXtype(xtype);
            }
        }

        private void addCfg(String type, String name, String descriptionLine) {
            ConfigAttribute configAttribute = new ConfigAttribute(name, type);
            this.cc.addCfg(configAttribute);
            this.setDescriptionHolder(configAttribute);
            if (descriptionLine.length() > 0) {
                this.description.append(descriptionLine).append('\n');
            }
        }

        private void startComment(String comment) {
            assert (!this.insideComment);
            this.insideComment = true;
            this.addComment(comment);
        }

        private void endComment() {
            assert (this.insideComment);
            this.setDescriptionHolder(null);
            this.insideComment = false;
        }

        private void addComment(String comment) {
            assert (this.insideComment);
            this.description.append(comment).append('\n');
        }

        void validateComponentClass(ComponentClass cc) {
            if (cc != null && cc.getImports().isEmpty()) {
                LOG.warn("No imports in Compontent class");
            }
        }

        void end() {
            this.addIfHasXtype(this.cc);
        }

        private String jsType2asType(String jsType) {
            int lastDotPos = jsType.lastIndexOf(46);
            return lastDotPos == -1 ? jsType : jsType.substring(0, lastDotPos).toLowerCase() + jsType.substring(lastDotPos);
        }

        private void addIfHasXtype(ComponentClass cc) {
            if (cc != null && cc.getXtype() != null) {
                this.validateComponentClass(cc);
                this.componentSuite.addComponentClass(cc);
            }
        }

        private void setDescriptionHolder(DescriptionHolder nextDescriptionHolder) {
            if (nextDescriptionHolder != this.descriptionHolder) {
                String cleanedDescription = TidyComment.tidy(this.description.toString()).trim();
                if (this.descriptionHolder != null && cleanedDescription.length() > 0) {
                    this.descriptionHolder.setDescription(cleanedDescription);
                }
                this.description = new StringBuilder();
                this.descriptionHolder = nextDescriptionHolder;
            }
        }

        private boolean isActionScript() {
            return this.srcFile.getName().lastIndexOf(".as") != -1;
        }

        public boolean isInConfig() {
            return this.descriptionHolder instanceof ConfigAttribute;
        }
    }
}

