/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.exml.configconverter;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import net.jangaroo.exml.configconverter.ComponentSuiteRegistry;
import net.jangaroo.exml.configconverter.file.SrcFileScanner;
import net.jangaroo.exml.configconverter.generation.ConfigClassGenerator;
import net.jangaroo.exml.configconverter.model.ComponentSuite;
import net.jangaroo.exml.configconverter.xml.XsdScanner;

public class ConfigConverterTool {
    private File sourceRoot;
    private File outputDir;
    private String newConfigPackage;
    private ComponentSuiteRegistry componentSuiteRegistry;
    private XsdScanner scanner;

    public ConfigConverterTool(File sourceRoot, File outputDir, String newConfigPackage) {
        this.sourceRoot = sourceRoot;
        this.outputDir = outputDir;
        this.newConfigPackage = newConfigPackage;
        this.componentSuiteRegistry = new ComponentSuiteRegistry();
        this.scanner = new XsdScanner(this.componentSuiteRegistry);
    }

    public void addModule(File xsd, String packageName) throws IOException {
        ComponentSuite componentSuite = this.scanner.scan(new FileInputStream(xsd));
        componentSuite.setConfigClassPackage(packageName);
        this.componentSuiteRegistry.add(componentSuite);
    }

    public void convertAll() throws IOException {
        ComponentSuite suite = new ComponentSuite(this.componentSuiteRegistry, "ignored", "ignored", this.sourceRoot, this.outputDir, this.newConfigPackage);
        SrcFileScanner fileScanner = new SrcFileScanner(suite);
        fileScanner.scan();
        ConfigClassGenerator generator = new ConfigClassGenerator(suite);
        generator.generateClasses();
    }
}

