/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.exml.configconverter;

import java.util.LinkedHashMap;
import java.util.Map;
import net.jangaroo.exml.configconverter.model.ComponentClass;
import net.jangaroo.exml.configconverter.model.ComponentSuite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ComponentSuiteRegistry {
    private final Logger log = LoggerFactory.getLogger(ComponentSuiteRegistry.class);
    private final Map<String, ComponentSuite> componentSuitesByNamespaceUri = new LinkedHashMap<String, ComponentSuite>(10);

    public void add(ComponentSuite componentSuite) {
        this.componentSuitesByNamespaceUri.put(componentSuite.getNamespace(), componentSuite);
        componentSuite.setRegistry(this);
    }

    public ComponentSuite getComponentSuite(String namespaceUri) {
        ComponentSuite componentSuite = this.componentSuitesByNamespaceUri.get(namespaceUri);
        if (componentSuite == null) {
            this.log.info("Component suite for namespace URI " + namespaceUri + " not found in registry.");
        }
        return componentSuite;
    }

    public ComponentClass getComponentClass(String namespaceUri, String localName) {
        ComponentSuite componentSuite = this.getComponentSuite(namespaceUri);
        return componentSuite != null ? componentSuite.getComponentClassByLocalName(localName) : null;
    }

    public ComponentClass findComponentClassByXtype(String xtype) {
        for (ComponentSuite suite : this.componentSuitesByNamespaceUri.values()) {
            ComponentClass componentClass = suite.getComponentClassByXtype(xtype);
            if (componentClass == null) continue;
            return componentClass;
        }
        return null;
    }

    public ComponentClass findComponentClassByFullClassName(String fullComponentClassName) {
        for (ComponentSuite suite : this.componentSuitesByNamespaceUri.values()) {
            ComponentClass componentClass = suite.getComponentClassByFullClassName(fullComponentClassName);
            if (componentClass == null) continue;
            return componentClass;
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (ComponentSuite suite : this.componentSuitesByNamespaceUri.values()) {
            sb.append(suite.getNamespace()).append(", ");
        }
        return sb.toString();
    }

    public void reset() {
        this.componentSuitesByNamespaceUri.clear();
    }
}

