/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.exml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Properties;
import net.jangaroo.exml.configconverter.ConfigConverterTool;
import net.jangaroo.exml.exmlconverter.ExmlConverterTool;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.ExampleMode;
import org.kohsuke.args4j.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExmlConverter {
    private final Logger log = LoggerFactory.getLogger(ExmlConverter.class);
    @Option(name="-m", aliases={"-module"}, usage="Maven module root folder that should be converted", metaVar="MODULE_DIRECTORY", required=true)
    private File moduleRoot;
    @Option(name="-e", usage="the optional character encoding of the EXML files; defaults to UTF-8", metaVar="ENCODING")
    private String encoding = "UTF-8";
    @Option(name="-p", aliases={"-mapping"}, usage="properties file with mapping of maven module name to config class package. Every dependency that provides some Exml components should be added to this file. Example: ext3=ext.config", metaVar="MAPPING_FILE", required=true)
    private File mappingPropertiesFile;
    @Option(name="-s", usage="the source path, relative to MODULE_DIRECTORY; defaults to src/main/joo")
    private String sourcePath = "src" + File.separator + "main" + File.separator + "joo" + File.separator;
    @Option(name="-o", usage="the output directory for the generated config classes. OUTPUT_DIRECTORY defaults to the source folder of the Maven module (src/main/joo)", metaVar="OUTPUT_DIRECTORY")
    private File outputDir;
    @Option(name="-t", aliases={"-test-output"}, metaVar="TEST_OUTPUT_DIR", usage="the Jangaroo test output directory. This is typically <module-root>/target/jangaroo-output-test or <module-root>/target/test-classes which will also be used if not specified. You have to provide this parameter if you have changed the value of <testOutputDirectory>target/jangaroo-output-test</testOutputDirectory> in your module pom.xml.")
    private File moduleJangarooTestOutputDir;

    void exit(int status) {
        System.exit(status);
    }

    public static void main(String[] args) throws IOException {
        new ExmlConverter().run(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void run(String[] args) throws IOException {
        Properties mappings;
        CmdLineParser parser = new CmdLineParser(this);
        parser.setUsageWidth(80);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            this.log.error(e.getMessage());
            this.printUsage(parser);
            this.exit(-3);
        }
        if (!this.moduleRoot.exists()) {
            this.log.error("The maven module root directory %s does not exist.", (Object)this.moduleRoot.getAbsolutePath());
            this.log.error("Please specify an existing path.");
            this.exit(-2);
        }
        String moduleName = this.moduleRoot.getName();
        if (!this.mappingPropertiesFile.exists()) {
            this.log.error("Mapping file %s does not exist.", (Object)this.mappingPropertiesFile.getAbsolutePath());
            this.log.error("Please specify an existing path.");
            this.exit(-2);
        }
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(this.mappingPropertiesFile);
            mappings = new Properties();
            mappings.load(stream);
            mappings.put("ext3", "ext.config");
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
        String configClassPackage = this.getConfigPackageName(moduleName, mappings);
        File moduleSourceRoot = new File(this.moduleRoot, this.sourcePath);
        if (!moduleSourceRoot.exists()) {
            this.log.error("Source folder %s does not exist.", (Object)moduleSourceRoot.getAbsolutePath());
            this.log.error("Is this really a Maven module?");
            this.exit(-2);
        }
        if (this.outputDir == null) {
            this.outputDir = moduleSourceRoot;
        }
        if (this.moduleJangarooTestOutputDir == null) {
            this.moduleJangarooTestOutputDir = new File(this.moduleRoot, "target" + File.separator + "jangaroo-output-test" + File.separator);
            if (!this.moduleJangarooTestOutputDir.exists()) {
                this.moduleJangarooTestOutputDir = new File(this.moduleRoot, "target" + File.separator + "test-classes" + File.separator);
                if (!this.moduleJangarooTestOutputDir.exists()) {
                    this.log.error("JANGAROO_TEST_OUTPUT_DIR %s does not exist.", (Object)this.moduleJangarooTestOutputDir.getAbsolutePath());
                    this.log.error("Is this really a Maven module or have you not called mvn install yet?");
                    this.exit(-2);
                }
            }
        }
        if (!this.moduleJangarooTestOutputDir.exists()) {
            this.log.error("JANGAROO_TEST_OUTPUT_DIR %s does not exist.", (Object)this.moduleJangarooTestOutputDir.getAbsolutePath());
            this.log.error("Is this really a Maven module or have you not called mvn install yet?");
            this.exit(-2);
        }
        ConfigConverterTool configConverter = new ConfigConverterTool(moduleSourceRoot, this.outputDir, configClassPackage);
        for (String module : mappings.stringPropertyNames()) {
            File xsd = new File(this.moduleJangarooTestOutputDir, module + ".xsd");
            if (!xsd.exists()) continue;
            configConverter.addModule(xsd, this.getConfigPackageName(module, mappings));
        }
        configConverter.convertAll();
        ExmlConverterTool exmlConverter = new ExmlConverterTool(this.encoding, moduleSourceRoot, mappings);
        boolean ok = exmlConverter.convertAll();
        if (!ok) {
            this.log.error("Some files could not be processed due to errors.");
            this.exit(-3);
        }
    }

    private String getConfigPackageName(String moduleName, Properties mappings) {
        String configClassPackage = mappings.getProperty(moduleName);
        if (configClassPackage == null || configClassPackage.length() == 0) {
            this.log.error("No config class package for module '" + moduleName + "' defined!");
            this.log.error("Please add some package name for the module '" + moduleName + "' to the mapping file " + this.mappingPropertiesFile);
            this.exit(-2);
        }
        return configClassPackage;
    }

    private void printUsage(CmdLineParser parser) {
        this.log.error("Usage: java -jar exml-converter.jar [options...]");
        this.log.error("Exml Converter that converts Exml Maven modules to the new Exml compiler.");
        this.log.error("Generates config classes from ExtJS components written in old style AS and converts all exml files.");
        this.log.error("Details can be found here: https://github.com/CoreMedia/jangaroo-tools/wiki/Exml-converter");
        this.log.error("");
        StringWriter writer = new StringWriter();
        parser.printUsage(writer, null);
        this.log.error(writer.toString());
        this.log.error("");
        this.log.error("  Example: java -jar exml-converter.jar" + parser.printExample(ExampleMode.REQUIRED));
    }
}

