/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.jdbc.core;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Objects;
import javax.sql.DataSource;
import net.hasor.db.datasource.ConnectionProxy;
import net.hasor.db.jdbc.ConnectionCallback;
import net.hasor.db.jdbc.core.JdbcAccessor;
import net.hasor.db.transaction.TranManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcConnection
extends JdbcAccessor {
    private static final Logger logger = LoggerFactory.getLogger(JdbcConnection.class);
    private int fetchSize = 0;
    private int maxRows = 0;
    private int queryTimeout = 0;

    public JdbcConnection() {
    }

    public JdbcConnection(DataSource dataSource) {
        this.setDataSource(dataSource);
    }

    public JdbcConnection(Connection conn) {
        this.setConnection(conn);
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setQueryTimeout(int queryTimeout) {
        this.queryTimeout = queryTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T execute(ConnectionCallback<T> action) throws SQLException {
        boolean usingDS;
        Objects.requireNonNull(action, "Callback object must not be null");
        Connection localConn = this.getConnection();
        DataSource localDS = this.getDataSource();
        boolean bl = usingDS = localConn == null;
        if (logger.isDebugEnabled()) {
            logger.debug("database connection using DataSource = {}", (Object)usingDS);
        }
        ConnectionProxy useConn = null;
        try {
            if (usingDS) {
                localConn = TranManager.currentConnection(localDS);
                useConn = this.newProxyConnection(localConn, localDS);
            } else {
                useConn = this.newProxyConnection(localConn, null);
            }
            T t = action.doInConnection(useConn);
            return t;
        }
        finally {
            if (usingDS && localConn != null) {
                localConn.close();
            }
        }
    }

    protected void applyStatementSettings(Statement stmt) throws SQLException {
        int timeout;
        int maxRows;
        int fetchSize = this.getFetchSize();
        if (fetchSize > 0) {
            stmt.setFetchSize(fetchSize);
        }
        if ((maxRows = this.getMaxRows()) > 0) {
            stmt.setMaxRows(maxRows);
        }
        if ((timeout = this.getQueryTimeout()) > 0) {
            stmt.setQueryTimeout(timeout);
        }
    }

    private ConnectionProxy newProxyConnection(Connection target, DataSource targetSource) {
        Objects.requireNonNull(target, "Connection is null.");
        CloseSuppressingInvocationHandler handler = new CloseSuppressingInvocationHandler(target, targetSource);
        return (ConnectionProxy)Proxy.newProxyInstance(ConnectionProxy.class.getClassLoader(), new Class[]{ConnectionProxy.class}, (InvocationHandler)handler);
    }

    private class CloseSuppressingInvocationHandler
    implements InvocationHandler {
        private final Connection target;
        private final DataSource targetSource;

        public CloseSuppressingInvocationHandler(Connection target, DataSource targetSource) {
            this.target = target;
            this.targetSource = targetSource;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("getTargetConnection")) {
                return this.target;
            }
            if (method.getName().equals("getTargetSource")) {
                return this.targetSource;
            }
            if (method.getName().equals("equals")) {
                return proxy == args[0];
            }
            if (method.getName().equals("hashCode")) {
                return System.identityHashCode(proxy);
            }
            if (method.getName().equals("close")) {
                return null;
            }
            try {
                Object retVal = method.invoke((Object)this.target, args);
                if (retVal instanceof Statement) {
                    JdbcConnection.this.applyStatementSettings((Statement)retVal);
                }
                return retVal;
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }
}

