/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.datasource;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import net.hasor.db.datasource.ConnectionHolder;

class CloseSuppressingInvocationHandler
implements InvocationHandler {
    private final ConnectionHolder holder;

    CloseSuppressingInvocationHandler(ConnectionHolder holder) {
        this.holder = holder;
        this.holder.requested();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Connection connection = this.holder.getConnection();
        if (method.getName().equals("getTargetConnection")) {
            return connection;
        }
        if (method.getName().equals("getTargetSource")) {
            return this.holder.getDataSource();
        }
        if (method.getName().equals("toString")) {
            return this.holder.toString();
        }
        if (method.getName().equals("equals")) {
            return proxy == args[0];
        }
        if (method.getName().equals("hashCode")) {
            return System.identityHashCode(proxy);
        }
        if (method.getName().equals("close")) {
            if (this.holder.isOpen()) {
                this.holder.released();
            }
            return null;
        }
        try {
            return method.invoke((Object)connection, args);
        }
        catch (InvocationTargetException ex) {
            throw ex.getTargetException();
        }
    }
}

