/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.runtime.operator.ops;

import net.hasor.dataql.Hints;
import net.hasor.dataql.runtime.InstructRuntimeException;
import net.hasor.dataql.runtime.Location;
import net.hasor.dataql.runtime.operator.OperatorUtils;
import net.hasor.dataql.runtime.operator.ops.AbstractDOP;

public class CompareDOP
extends AbstractDOP {
    private static final Integer BOOL_FALSE = 0;
    private static final Integer BOOL_TRUE = 1;

    @Override
    public Object doDyadicProcess(Location.RuntimeLocation location, String operator, Object fstObject, Object secObject, Hints option) throws InstructRuntimeException {
        if (OperatorUtils.isBoolean(fstObject) && OperatorUtils.isBoolean(secObject)) {
            fstObject = Boolean.TRUE.equals(fstObject) ? BOOL_TRUE : BOOL_FALSE;
            Object object = secObject = Boolean.TRUE.equals(secObject) ? BOOL_TRUE : BOOL_FALSE;
        }
        if (OperatorUtils.isBoolean(fstObject) && OperatorUtils.isNumber(secObject)) {
            fstObject = Boolean.TRUE.equals(fstObject) ? BOOL_TRUE : BOOL_FALSE;
            Object object = secObject = OperatorUtils.eq((Number)secObject, 0) ? BOOL_FALSE : BOOL_TRUE;
        }
        if (OperatorUtils.isNumber(fstObject) && OperatorUtils.isBoolean(secObject)) {
            fstObject = OperatorUtils.eq((Number)fstObject, 0) ? BOOL_FALSE : BOOL_TRUE;
            Object object = secObject = Boolean.TRUE.equals(secObject) ? BOOL_TRUE : BOOL_FALSE;
        }
        if (">".equals(operator)) {
            return OperatorUtils.gt((Number)fstObject, (Number)secObject);
        }
        if (">=".equals(operator)) {
            return OperatorUtils.gteq((Number)fstObject, (Number)secObject);
        }
        if ("<".equals(operator)) {
            return OperatorUtils.lt((Number)fstObject, (Number)secObject);
        }
        if ("<=".equals(operator)) {
            return OperatorUtils.lteq((Number)fstObject, (Number)secObject);
        }
        if ("==".equals(operator)) {
            return OperatorUtils.eq((Number)fstObject, (Number)secObject);
        }
        if ("!=".equals(operator)) {
            return !OperatorUtils.eq((Number)fstObject, (Number)secObject);
        }
        if ("&&".equals(operator) || "||".equals(operator)) {
            boolean fstBool = OperatorUtils.isNumber(fstObject) ? !OperatorUtils.eq((Number)fstObject, 0) : Boolean.TRUE.equals(fstObject);
            boolean secBool = OperatorUtils.isNumber(secObject) ? !OperatorUtils.eq((Number)secObject, 0) : Boolean.TRUE.equals(secObject);
            if ("&&".equals(operator)) {
                return fstBool && secBool;
            }
            if ("||".equals(operator)) {
                return fstBool || secBool;
            }
        }
        throw CompareDOP.throwError(location, operator, fstObject, secObject, "this operator nonsupport.");
    }
}

