/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.runtime.inset;

import java.util.function.Supplier;
import net.hasor.core.provider.SingleProvider;
import net.hasor.dataql.runtime.InsetProcess;
import net.hasor.dataql.runtime.InsetProcessContext;
import net.hasor.dataql.runtime.InstSequence;
import net.hasor.dataql.runtime.InstructRuntimeException;
import net.hasor.dataql.runtime.Location;
import net.hasor.dataql.runtime.inset.CALL;
import net.hasor.dataql.runtime.inset.CAST_I;
import net.hasor.dataql.runtime.inset.CAST_O;
import net.hasor.dataql.runtime.inset.COPY;
import net.hasor.dataql.runtime.inset.DO;
import net.hasor.dataql.runtime.inset.EXIT;
import net.hasor.dataql.runtime.inset.E_LOAD;
import net.hasor.dataql.runtime.inset.E_POP;
import net.hasor.dataql.runtime.inset.E_PUSH;
import net.hasor.dataql.runtime.inset.GET;
import net.hasor.dataql.runtime.inset.GOTO;
import net.hasor.dataql.runtime.inset.HINT;
import net.hasor.dataql.runtime.inset.IF;
import net.hasor.dataql.runtime.inset.LABEL;
import net.hasor.dataql.runtime.inset.LDC_B;
import net.hasor.dataql.runtime.inset.LDC_D;
import net.hasor.dataql.runtime.inset.LDC_N;
import net.hasor.dataql.runtime.inset.LDC_S;
import net.hasor.dataql.runtime.inset.LINE;
import net.hasor.dataql.runtime.inset.LOAD;
import net.hasor.dataql.runtime.inset.LOAD_C;
import net.hasor.dataql.runtime.inset.LOCAL;
import net.hasor.dataql.runtime.inset.M_DEF;
import net.hasor.dataql.runtime.inset.M_FRAG;
import net.hasor.dataql.runtime.inset.M_REF;
import net.hasor.dataql.runtime.inset.M_TYP;
import net.hasor.dataql.runtime.inset.NEW_A;
import net.hasor.dataql.runtime.inset.NEW_O;
import net.hasor.dataql.runtime.inset.POP;
import net.hasor.dataql.runtime.inset.PULL;
import net.hasor.dataql.runtime.inset.PUSH;
import net.hasor.dataql.runtime.inset.PUT;
import net.hasor.dataql.runtime.inset.RETURN;
import net.hasor.dataql.runtime.inset.STORE;
import net.hasor.dataql.runtime.inset.THROW;
import net.hasor.dataql.runtime.inset.TYPEOF;
import net.hasor.dataql.runtime.inset.UO;
import net.hasor.dataql.runtime.mem.DataHeap;
import net.hasor.dataql.runtime.mem.DataStack;
import net.hasor.dataql.runtime.mem.EnvStack;

public class OpcodesPool {
    private final InsetProcess[] processes = new InsetProcess[255];
    private static final Supplier<OpcodesPool> operatorManager = new SingleProvider(OpcodesPool::initPool);

    private void addInsetProcess(InsetProcess inst) {
        this.processes[inst.getOpcode()] = inst;
    }

    public void doWork(InstSequence sequence, DataHeap dataHeap, DataStack dataStack, EnvStack envStack, InsetProcessContext context) throws InstructRuntimeException {
        Location.RuntimeLocation location = sequence.programLocation();
        try {
            InsetProcess process = this.processes[sequence.currentInst().getInstCode()];
            process.doWork(sequence, dataHeap, dataStack, envStack, context);
        }
        catch (Exception e) {
            InstructRuntimeException ire = null;
            ire = e instanceof InstructRuntimeException ? (InstructRuntimeException)e : new InstructRuntimeException(location, (Throwable)e);
            throw ire;
        }
    }

    public static OpcodesPool defaultOpcodesPool() {
        return operatorManager.get();
    }

    private static OpcodesPool initPool() {
        OpcodesPool pool = new OpcodesPool();
        pool.addInsetProcess(new LDC_B());
        pool.addInsetProcess(new LDC_D());
        pool.addInsetProcess(new LDC_S());
        pool.addInsetProcess(new LDC_N());
        pool.addInsetProcess(new NEW_O());
        pool.addInsetProcess(new NEW_A());
        pool.addInsetProcess(new LOAD());
        pool.addInsetProcess(new STORE());
        pool.addInsetProcess(new GET());
        pool.addInsetProcess(new PUT());
        pool.addInsetProcess(new PULL());
        pool.addInsetProcess(new PUSH());
        pool.addInsetProcess(new COPY());
        pool.addInsetProcess(new RETURN());
        pool.addInsetProcess(new EXIT());
        pool.addInsetProcess(new THROW());
        pool.addInsetProcess(new UO());
        pool.addInsetProcess(new DO());
        pool.addInsetProcess(new TYPEOF());
        pool.addInsetProcess(new IF());
        pool.addInsetProcess(new GOTO());
        pool.addInsetProcess(new HINT());
        pool.addInsetProcess(new POP());
        pool.addInsetProcess(new LOAD_C());
        pool.addInsetProcess(new E_PUSH());
        pool.addInsetProcess(new E_POP());
        pool.addInsetProcess(new E_LOAD());
        pool.addInsetProcess(new CAST_I());
        pool.addInsetProcess(new CAST_O());
        pool.addInsetProcess(new CALL());
        pool.addInsetProcess(new M_REF());
        pool.addInsetProcess(new M_DEF());
        pool.addInsetProcess(new M_TYP());
        pool.addInsetProcess(new M_FRAG());
        pool.addInsetProcess(new LOCAL());
        pool.addInsetProcess(new LABEL());
        pool.addInsetProcess(new LINE());
        return pool;
    }
}

