/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.runtime.inset;

import net.hasor.dataql.domain.DataModel;
import net.hasor.dataql.runtime.InsetProcess;
import net.hasor.dataql.runtime.InsetProcessContext;
import net.hasor.dataql.runtime.InstSequence;
import net.hasor.dataql.runtime.InstructRuntimeException;
import net.hasor.dataql.runtime.mem.DataHeap;
import net.hasor.dataql.runtime.mem.DataStack;
import net.hasor.dataql.runtime.mem.EnvStack;
import net.hasor.dataql.runtime.operator.OperatorProcess;
import net.hasor.dataql.runtime.operator.OperatorUtils;

class DO
implements InsetProcess {
    DO() {
    }

    @Override
    public int getOpcode() {
        return 42;
    }

    @Override
    public void doWork(InstSequence sequence, DataHeap dataHeap, DataStack dataStack, EnvStack envStack, InsetProcessContext context) throws InstructRuntimeException {
        Class secType;
        Class fstType;
        OperatorProcess process;
        String dyadicSymbol = sequence.currentInst().getString(0);
        Object secExpData = dataStack.pop();
        Object fstExpData = dataStack.pop();
        if (fstExpData instanceof DataModel) {
            fstExpData = ((DataModel)fstExpData).asOri();
        }
        if (secExpData instanceof DataModel) {
            secExpData = ((DataModel)secExpData).asOri();
        }
        if ("/".equals(dyadicSymbol)) {
            Number number;
            boolean isPositive = true;
            if (OperatorUtils.isNumber(fstExpData)) {
                number = (Number)fstExpData;
                if (!OperatorUtils.isDecimal(number)) {
                    fstExpData = OperatorUtils.multiply(number, 1.0);
                }
            } else {
                String msg = fstExpData == null ? "is null." : "must number.";
                throw new InstructRuntimeException(sequence.programLocation(), "DO -> first data " + msg);
            }
            isPositive = OperatorUtils.gteq(number, 0);
            if (secExpData == null) {
                secExpData = 0;
            }
            if (OperatorUtils.isNumber(secExpData) && OperatorUtils.eq((Number)secExpData, 0)) {
                if (isPositive) {
                    dataStack.push(Double.POSITIVE_INFINITY);
                } else {
                    dataStack.push(Double.NEGATIVE_INFINITY);
                }
                return;
            }
        }
        if ((process = context.findDyadicOperator(dyadicSymbol, fstType = fstExpData == null ? Void.class : fstExpData.getClass(), secType = secExpData == null ? Void.class : secExpData.getClass())) == null) {
            throw new InstructRuntimeException(sequence.programLocation(), "DO -> '" + fstType.getName() + "' and '" + secType.getName() + "' operation '" + dyadicSymbol + "' not support.");
        }
        Object result = process.doProcess(sequence.programLocation(), dyadicSymbol, new Object[]{fstExpData, secExpData}, context);
        dataStack.push(result);
    }
}

