/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.runtime;

import net.hasor.dataql.compiler.ast.CodeLocation;

public abstract class Location
extends CodeLocation.CodeLocationInfo {
    public String toErrorMessage() {
        return "line " + super.toString();
    }

    public static RuntimeLocation atRuntime(CodeLocation codeLocation, int methodAddress, int programAddress) {
        return new RuntimeLocation(codeLocation, methodAddress, programAddress);
    }

    public static RuntimeLocation unknownLocation() {
        CodeLocation.CodeLocationInfo codeLocation = new CodeLocation.CodeLocationInfo();
        codeLocation.setStartPosition(new CodeLocation.CodePosition(-1, -1));
        codeLocation.setEndPosition(new CodeLocation.CodePosition(-1, -1));
        return new RuntimeLocation(codeLocation, -1, -1);
    }

    public static class RuntimeLocation
    extends Location {
        private int methodAddress = -1;
        private int programAddress = -1;

        private RuntimeLocation(CodeLocation codeLocation, int methodAddress, int programAddress) {
            this.setStartPosition(codeLocation.getStartPosition());
            this.setEndPosition(codeLocation.getEndPosition());
            this.methodAddress = methodAddress;
            this.programAddress = programAddress;
        }

        public int getMethodAddress() {
            return this.methodAddress;
        }

        public int getProgramAddress() {
            return this.programAddress;
        }

        @Override
        public String toErrorMessage() {
            return super.toErrorMessage() + " ,QIL " + this.methodAddress + ":" + this.programAddress;
        }
    }
}

