/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.compiler.ast.value;

import java.io.IOException;
import net.hasor.dataql.Hints;
import net.hasor.dataql.compiler.ast.AstVisitor;
import net.hasor.dataql.compiler.ast.CodeLocation;
import net.hasor.dataql.compiler.ast.Expression;
import net.hasor.dataql.compiler.ast.FormatWriter;
import net.hasor.dataql.compiler.ast.InstVisitorContext;
import net.hasor.dataql.compiler.ast.RouteVariable;
import net.hasor.dataql.compiler.ast.Variable;
import net.hasor.dataql.compiler.ast.expr.AtomExpression;
import net.hasor.dataql.compiler.ast.expr.PrivilegeExpression;
import net.hasor.dataql.compiler.ast.token.IntegerToken;
import net.hasor.dataql.compiler.ast.token.StringToken;
import net.hasor.dataql.compiler.ast.value.EnterRouteVariable;

public class SubscriptRouteVariable
extends CodeLocation.CodeLocationInfo
implements Variable,
RouteVariable {
    private final RouteVariable parent;
    private final SubType subType;
    private StringToken subValue;
    private Expression exprValue;

    public SubscriptRouteVariable(RouteVariable parent, IntegerToken subValue) {
        this.subType = SubType.Integer;
        this.parent = parent;
        this.subValue = subValue.toStringToken();
    }

    public SubscriptRouteVariable(RouteVariable parent, StringToken subValue) {
        this.subType = SubType.String;
        this.parent = parent;
        this.subValue = subValue;
    }

    public SubscriptRouteVariable(RouteVariable parent, Expression exprValue) {
        this.subType = SubType.Expr;
        this.parent = parent;
        this.exprValue = exprValue;
    }

    @Override
    public RouteVariable getParent() {
        return this.parent;
    }

    public SubType getSubType() {
        return this.subType;
    }

    public StringToken getSubValue() {
        return this.subValue;
    }

    public Expression getExprValue() {
        return this.exprValue;
    }

    @Override
    public void accept(AstVisitor astVisitor) {
        if (this.parent != null) {
            this.parent.accept(astVisitor);
        }
        astVisitor.visitInst(new InstVisitorContext(this){

            @Override
            public void visitChildren(AstVisitor astVisitor) {
            }
        });
    }

    @Override
    public void doFormat(int depth, Hints formatOption, FormatWriter writer) throws IOException {
        this.parent.doFormat(depth, formatOption, writer);
        if (this.parent instanceof EnterRouteVariable) {
            EnterRouteVariable.RouteType routeType = ((EnterRouteVariable)this.parent).getRouteType();
            EnterRouteVariable.SpecialType specialType = ((EnterRouteVariable)this.parent).getSpecialType();
            if (specialType == null) {
                specialType = EnterRouteVariable.SpecialType.Special_A;
            }
            writer.write(specialType.getCode());
        }
        if (this.subType == SubType.String) {
            String newValue = this.subValue.getValue().replace(String.valueOf('\"'), "\\\"");
            writer.write("[\"" + newValue + '\"' + "]");
        } else if (this.subType == SubType.Integer) {
            writer.write("[" + this.subValue.getValue() + "]");
        } else {
            writer.write("[");
            Variable varExp = this.exprValue;
            while (varExp instanceof PrivilegeExpression) {
                varExp = ((PrivilegeExpression)varExp).getExpression();
            }
            if (varExp instanceof AtomExpression) {
                varExp = ((AtomExpression)varExp).getVariableExpression();
            }
            if (varExp instanceof EnterRouteVariable) {
                writer.write(((EnterRouteVariable)varExp).getSpecialType().getCode());
            } else {
                varExp.doFormat(depth, formatOption, writer);
            }
            writer.write("]");
        }
    }

    public static enum SubType {
        String,
        Integer,
        Expr;

    }
}

