/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.compiler.ast.value;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.hasor.dataql.Hints;
import net.hasor.dataql.compiler.ast.AstVisitor;
import net.hasor.dataql.compiler.ast.FormatWriter;
import net.hasor.dataql.compiler.ast.Inst;
import net.hasor.dataql.compiler.ast.InstVisitorContext;
import net.hasor.dataql.compiler.ast.Variable;
import net.hasor.dataql.compiler.ast.inst.InstSet;
import net.hasor.dataql.compiler.ast.token.StringToken;

public class LambdaVariable
extends InstSet
implements Variable {
    private final Map<String, StringToken> paramMap = new HashMap<String, StringToken>();
    private final List<StringToken> paramList = new ArrayList<StringToken>();

    public LambdaVariable() {
        super(true);
    }

    public void addParam(StringToken name) {
        if (this.paramMap.containsKey(name.getValue())) {
            throw new IllegalStateException(name + " param existing.");
        }
        this.paramMap.put(name.getValue(), name);
        this.paramList.add(name);
    }

    public List<StringToken> getParamList() {
        return this.paramList;
    }

    @Override
    public void accept(AstVisitor astVisitor) {
        astVisitor.visitInst(new InstVisitorContext(this){

            @Override
            public void visitChildren(AstVisitor astVisitor) {
                for (Inst var : LambdaVariable.this) {
                    var.accept(astVisitor);
                }
            }
        });
    }

    @Override
    public void doFormat(int depth, Hints formatOption, FormatWriter writer) throws IOException {
        writer.write("(");
        for (int i = 0; i < this.paramList.size(); ++i) {
            if (i > 0) {
                writer.write(", ");
            }
            writer.write(this.paramList.get(i).getValue());
        }
        writer.write(") -> ");
        if (this.isMultipleInst()) {
            super.doFormat(depth - 1, formatOption, writer);
        } else {
            super.doFormat(0, formatOption, writer);
        }
    }
}

