/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.compiler.ast.inst;

import java.io.IOException;
import net.hasor.dataql.Hints;
import net.hasor.dataql.compiler.ast.AstVisitor;
import net.hasor.dataql.compiler.ast.CodeLocation;
import net.hasor.dataql.compiler.ast.FormatWriter;
import net.hasor.dataql.compiler.ast.Inst;
import net.hasor.dataql.compiler.ast.InstVisitorContext;
import net.hasor.dataql.compiler.ast.Variable;
import net.hasor.dataql.compiler.ast.token.StringToken;
import net.hasor.dataql.compiler.ast.value.LambdaVariable;
import net.hasor.utils.StringUtils;

public class VarInst
extends CodeLocation.CodeLocationInfo
implements Inst {
    private final StringToken varName;
    private final Variable value;

    public VarInst(StringToken varName, Variable value) {
        this.varName = varName;
        this.value = value;
    }

    public StringToken getVarName() {
        return this.varName;
    }

    public Variable getValue() {
        return this.value;
    }

    @Override
    public void accept(AstVisitor astVisitor) {
        astVisitor.visitInst(new InstVisitorContext(this){

            @Override
            public void visitChildren(AstVisitor astVisitor) {
                VarInst.this.value.accept(astVisitor);
            }
        });
    }

    @Override
    public void doFormat(int depth, Hints formatOption, FormatWriter writer) throws IOException {
        String fixedString = StringUtils.fixedString((char)' ', (int)(depth * 4));
        writer.write(fixedString + String.format("var %s = ", this.varName.getValue()));
        this.value.doFormat(depth, formatOption, writer);
        if (this.value instanceof LambdaVariable) {
            return;
        }
        writer.write(";\n");
    }
}

