/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.compiler.ast.inst;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.hasor.dataql.Hints;
import net.hasor.dataql.compiler.ast.AstVisitor;
import net.hasor.dataql.compiler.ast.CodeLocation;
import net.hasor.dataql.compiler.ast.Expression;
import net.hasor.dataql.compiler.ast.FormatWriter;
import net.hasor.dataql.compiler.ast.Inst;
import net.hasor.dataql.compiler.ast.InstVisitorContext;
import net.hasor.dataql.compiler.ast.inst.InstSet;
import net.hasor.utils.StringUtils;

public class SwitchInst
extends CodeLocation.CodeLocationInfo
implements Inst {
    private final List<SwitchExpression> testBlockSet = new ArrayList<SwitchExpression>();
    private InstSet elseBlockSet = null;

    public List<SwitchExpression> getTestBlockSet() {
        return this.testBlockSet;
    }

    public InstSet getElseBlockSet() {
        return this.elseBlockSet;
    }

    public void addElseif(Expression testExp, InstSet blockSet) {
        SwitchExpression se = new SwitchExpression();
        se.testExpression = testExp;
        se.instBlockSet = blockSet;
        this.testBlockSet.add(se);
    }

    public void setElseBlockSet(InstSet instBlockSet) {
        this.elseBlockSet = instBlockSet;
    }

    @Override
    public void accept(AstVisitor astVisitor) {
        astVisitor.visitInst(new InstVisitorContext(this){

            @Override
            public void visitChildren(AstVisitor astVisitor) {
                for (SwitchExpression switchExpr : SwitchInst.this.testBlockSet) {
                    switchExpr.testExpression.accept(astVisitor);
                    switchExpr.instBlockSet.accept(astVisitor);
                }
                if (SwitchInst.this.elseBlockSet != null) {
                    SwitchInst.this.elseBlockSet.accept(astVisitor);
                }
            }
        });
    }

    @Override
    public void doFormat(int depth, Hints formatOption, FormatWriter writer) throws IOException {
        String fixedString = StringUtils.fixedString((char)' ', (int)(depth * 4));
        writer.write(fixedString + "if (");
        SwitchExpression switchExpr = this.testBlockSet.get(0);
        switchExpr.testExpression.doFormat(depth + 1, formatOption, writer);
        if (switchExpr.instBlockSet.isMultipleInst()) {
            writer.write(") ");
            switchExpr.instBlockSet.doFormat(depth, formatOption, writer);
        } else {
            writer.write(")\n");
            switchExpr.instBlockSet.doFormat(depth + 1, formatOption, writer);
        }
        for (int i = 1; i < this.testBlockSet.size(); ++i) {
            switchExpr = this.testBlockSet.get(i);
            writer.write(" else if (");
            switchExpr.testExpression.doFormat(depth + 1, formatOption, writer);
            if (switchExpr.instBlockSet.isMultipleInst()) {
                writer.write(") ");
                switchExpr.instBlockSet.doFormat(depth, formatOption, writer);
                writer.write(" ");
                continue;
            }
            writer.write(")\n");
            switchExpr.instBlockSet.doFormat(depth + 1, formatOption, writer);
        }
        if (this.elseBlockSet == null) {
            return;
        }
        if (this.elseBlockSet.isMultipleInst()) {
            writer.write(fixedString + "else ");
            this.elseBlockSet.doFormat(depth, formatOption, writer);
            writer.write("\n");
        } else {
            writer.write(fixedString + "else\n");
            this.elseBlockSet.doFormat(depth + 1, formatOption, writer);
        }
    }

    public static class SwitchExpression {
        public Expression testExpression;
        public InstSet instBlockSet;
    }
}

