/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.compiler.ast.inst;

import java.io.IOException;
import net.hasor.dataql.Hints;
import net.hasor.dataql.compiler.ast.AstVisitor;
import net.hasor.dataql.compiler.ast.CodeLocation;
import net.hasor.dataql.compiler.ast.FormatWriter;
import net.hasor.dataql.compiler.ast.Inst;
import net.hasor.dataql.compiler.ast.InstVisitorContext;
import net.hasor.dataql.compiler.ast.Variable;
import net.hasor.dataql.compiler.ast.token.IntegerToken;
import net.hasor.dataql.compiler.ast.value.LambdaVariable;
import net.hasor.utils.StringUtils;

public class ReturnInst
extends CodeLocation.CodeLocationInfo
implements Inst {
    private final IntegerToken returnCode;
    private final Variable resultData;

    public ReturnInst(IntegerToken returnCode, Variable resultData) {
        this.returnCode = returnCode;
        this.resultData = resultData;
    }

    public IntegerToken getReturnCode() {
        return this.returnCode;
    }

    public Variable getResultData() {
        return this.resultData;
    }

    @Override
    public void accept(AstVisitor astVisitor) {
        astVisitor.visitInst(new InstVisitorContext(this){

            @Override
            public void visitChildren(AstVisitor astVisitor) {
                ReturnInst.this.resultData.accept(astVisitor);
            }
        });
    }

    @Override
    public void doFormat(int depth, Hints formatOption, FormatWriter writer) throws IOException {
        String fixedString = StringUtils.fixedString((char)' ', (int)(depth * 4));
        if (this.returnCode.getValue() != 0) {
            writer.write(fixedString + String.format("return %s, ", this.returnCode.getValue()));
        } else {
            writer.write(fixedString + "return ");
        }
        this.resultData.doFormat(depth + 1, formatOption, writer);
        writer.write(this.resultData instanceof LambdaVariable ? "\n" : ";\n");
    }
}

