/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.compiler.ast.inst;

import java.io.IOException;
import net.hasor.dataql.Hints;
import net.hasor.dataql.compiler.ast.AstVisitor;
import net.hasor.dataql.compiler.ast.CodeLocation;
import net.hasor.dataql.compiler.ast.FormatWriter;
import net.hasor.dataql.compiler.ast.Inst;
import net.hasor.dataql.compiler.ast.InstVisitorContext;
import net.hasor.dataql.compiler.ast.token.StringToken;

public class ImportInst
extends CodeLocation.CodeLocationInfo
implements Inst {
    private ImportType importType = null;
    private StringToken importName = null;
    private StringToken asName = null;

    public ImportInst(ImportType importType, StringToken importName, StringToken asName) {
        this.importType = importType;
        this.importName = importName;
        this.asName = asName;
    }

    public ImportType getImportType() {
        return this.importType;
    }

    public StringToken getImportName() {
        return this.importName;
    }

    public StringToken getAsName() {
        return this.asName;
    }

    @Override
    public void accept(AstVisitor astVisitor) {
        astVisitor.visitInst(new InstVisitorContext(this){

            @Override
            public void visitChildren(AstVisitor astVisitor) {
            }
        });
    }

    @Override
    public void doFormat(int depth, Hints formatOption, FormatWriter writer) throws IOException {
        writer.write("import ");
        if (this.importType == ImportType.Resource) {
            writer.write("@");
        } else if (this.importType == ImportType.ClassType) {
            // empty if block
        }
        writer.write('\"' + this.importName.getValue() + '\"');
        writer.write(" as " + this.asName.getValue() + ";\n");
    }

    public static enum ImportType {
        Resource,
        ClassType;

    }
}

