/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.compiler.ast.expr;

import java.io.IOException;
import net.hasor.dataql.Hints;
import net.hasor.dataql.compiler.ast.AstVisitor;
import net.hasor.dataql.compiler.ast.CodeLocation;
import net.hasor.dataql.compiler.ast.Expression;
import net.hasor.dataql.compiler.ast.FormatWriter;
import net.hasor.dataql.compiler.ast.InstVisitorContext;
import net.hasor.dataql.compiler.ast.token.SymbolToken;

public class DyadicExpression
extends CodeLocation.CodeLocationInfo
implements Expression {
    private final Expression fstExpression;
    private final SymbolToken symbolToken;
    private final Expression secExpression;

    public DyadicExpression(Expression fstExpression, SymbolToken symbolToken, Expression secExpression) {
        this.fstExpression = fstExpression;
        this.symbolToken = symbolToken;
        this.secExpression = secExpression;
    }

    @Override
    public CodeLocation expressCodeLocation() {
        CodeLocation.CodeLocationInfo codeLocation = new CodeLocation.CodeLocationInfo();
        codeLocation.setStartPosition(this.fstExpression.getStartPosition());
        codeLocation.setEndPosition(this.secExpression.getEndPosition());
        return codeLocation;
    }

    public Expression getFstExpression() {
        return this.fstExpression;
    }

    public SymbolToken getDyadicSymbol() {
        return this.symbolToken;
    }

    public Expression getSecExpression() {
        return this.secExpression;
    }

    @Override
    public void accept(AstVisitor astVisitor) {
        astVisitor.visitInst(new InstVisitorContext(this){

            @Override
            public void visitChildren(AstVisitor astVisitor) {
                DyadicExpression.this.fstExpression.accept(astVisitor);
                DyadicExpression.this.secExpression.accept(astVisitor);
            }
        });
    }

    @Override
    public void doFormat(int depth, Hints formatOption, FormatWriter writer) throws IOException {
        this.fstExpression.doFormat(depth, formatOption, writer);
        writer.write(" " + this.symbolToken.getSymbol() + " ");
        this.secExpression.doFormat(depth, formatOption, writer);
    }
}

