/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.binder;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.hasor.core.AppContext;
import net.hasor.dataql.Finder;
import net.hasor.dataql.FragmentProcess;
import net.hasor.utils.ExceptionUtils;
import net.hasor.utils.ResourcesUtils;
import net.hasor.utils.ref.LinkedCaseInsensitiveMap;

public class AppContextFinder
implements Finder {
    private AppContext appContext;
    private Map<String, Supplier<? extends FragmentProcess>> fragmentProcessMap;

    public AppContextFinder(AppContext appContext) {
        this.appContext = appContext;
        this.fragmentProcessMap = new LinkedCaseInsensitiveMap();
        List bindInfos = this.appContext.findBindingRegister(FragmentProcess.class);
        if (bindInfos != null) {
            bindInfos.forEach(fragmentInfo -> {
                Supplier fragmentProcess = appContext.getProvider(fragmentInfo);
                this.fragmentProcessMap.put(fragmentInfo.getBindName().toLowerCase(), fragmentProcess);
            });
        }
    }

    @Override
    public InputStream findResource(String resourceName) throws IOException {
        InputStream inputStream = null;
        try {
            ClassLoader classLoader = this.appContext.getEnvironment().getClassLoader();
            if (classLoader != null) {
                resourceName = ResourcesUtils.formatResource((String)resourceName);
                inputStream = classLoader.getResourceAsStream(resourceName);
            } else {
                inputStream = ResourcesUtils.getResourceAsStream((String)resourceName);
            }
        }
        catch (Exception e) {
            String finalResourceName = resourceName;
            throw ExceptionUtils.toRuntimeException((Throwable)e, throwable -> new RuntimeException("import compiler failed -> '" + finalResourceName + "' not found.", (Throwable)throwable));
        }
        return inputStream;
    }

    @Override
    public Object findBean(Class<?> beanType) {
        return this.appContext.getInstance(beanType);
    }

    @Override
    public FragmentProcess findFragmentProcess(String fragmentType) {
        Supplier<? extends FragmentProcess> fragmentProcessSupplier = this.fragmentProcessMap.get(fragmentType.toLowerCase());
        if (fragmentProcessSupplier == null) {
            return (FragmentProcess)this.appContext.findBindingBean(fragmentType, FragmentProcess.class);
        }
        return fragmentProcessSupplier.get();
    }

    public void addFragmentProcess(String name, Supplier<? extends FragmentProcess> provider) {
        this.fragmentProcessMap.put(name, provider);
    }
}

