/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.hasor.core.ApiBinder;
import net.hasor.core.BindInfo;
import net.hasor.core.Environment;
import net.hasor.core.HasorUtils;
import net.hasor.core.TypeSupplier;
import net.hasor.core.aop.AsmTools;
import net.hasor.core.exts.aop.Matchers;
import net.hasor.dataql.DataQL;
import net.hasor.dataql.DimFragment;
import net.hasor.dataql.DimUdf;
import net.hasor.dataql.DimUdfSource;
import net.hasor.dataql.Finder;
import net.hasor.dataql.FragmentProcess;
import net.hasor.dataql.Hints;
import net.hasor.dataql.Udf;
import net.hasor.dataql.UdfSource;

public interface QueryApiBinder
extends ApiBinder,
Hints {
    public void configOption(DataQL.ConfigOption var1, Object var2);

    default public QueryApiBinder loadFragment(Set<Class<?>> fragmentTypeSet) {
        return this.loadFragment(fragmentTypeSet, Matchers.anyClass(), null);
    }

    default public QueryApiBinder loadFragment(Set<Class<?>> mabyFragmentTypeSet, Predicate<Class<?>> matcher, TypeSupplier typeSupplier) {
        if (mabyFragmentTypeSet != null && !mabyFragmentTypeSet.isEmpty()) {
            mabyFragmentTypeSet.stream().filter(matcher).filter(Matchers.annotatedWithClass(DimFragment.class)).forEach((? super T aClass) -> this.loadFragment((Class<?>)aClass, typeSupplier));
        }
        return this;
    }

    default public void loadFragment(Class<?> fragmentType) {
        this.loadFragment(fragmentType, null);
    }

    default public void loadFragment(Class<?> fragmentType, TypeSupplier typeSupplier) {
        Objects.requireNonNull(fragmentType, "class is null.");
        int modifier = fragmentType.getModifiers();
        if (AsmTools.checkOr((int)modifier, (int[])new int[]{512, 1024}) || fragmentType.isArray() || fragmentType.isEnum()) {
            throw new IllegalStateException(fragmentType.getName() + " must be normal Bean");
        }
        DimFragment annotationsByType = fragmentType.getAnnotation(DimFragment.class);
        if (annotationsByType == null) {
            throw new IllegalStateException(fragmentType.getName() + " must be configure @DimFragment");
        }
        if (!FragmentProcess.class.isAssignableFrom(fragmentType)) {
            throw new ClassCastException(fragmentType.getName() + " is not " + FragmentProcess.class.getName());
        }
        Supplier processSupplier = null;
        Class<?> processType = fragmentType;
        processSupplier = typeSupplier != null ? () -> (FragmentProcess)typeSupplier.get(processType) : this.getProvider(processType);
        this.bindFragment(annotationsByType.value(), processSupplier);
    }

    default public QueryApiBinder loadUdf(Set<Class<?>> udfTypeSet) {
        return this.loadUdf(udfTypeSet, Matchers.anyClass(), null);
    }

    default public QueryApiBinder loadUdf(Set<Class<?>> mabyUdfTypeSet, Predicate<Class<?>> matcher, TypeSupplier typeSupplier) {
        if (mabyUdfTypeSet != null && !mabyUdfTypeSet.isEmpty()) {
            mabyUdfTypeSet.stream().filter(matcher).filter(Matchers.annotatedWithClass(DimUdf.class)).forEach((? super T aClass) -> this.loadUdf((Class<?>)aClass, typeSupplier));
        }
        return this;
    }

    default public void loadUdf(Class<?> udfType) {
        this.loadUdf(udfType, null);
    }

    default public void loadUdf(Class<?> udfType, TypeSupplier typeSupplier) {
        Objects.requireNonNull(udfType, "class is null.");
        int modifier = udfType.getModifiers();
        if (AsmTools.checkOr((int)modifier, (int[])new int[]{512, 1024}) || udfType.isArray() || udfType.isEnum()) {
            throw new IllegalStateException(udfType.getName() + " must be normal Bean");
        }
        DimUdf annotationsByType = udfType.getAnnotation(DimUdf.class);
        if (annotationsByType == null) {
            throw new IllegalStateException(udfType.getName() + " must be configure @DimUdf");
        }
        if (!Udf.class.isAssignableFrom(udfType)) {
            throw new ClassCastException(udfType.getName() + " is not " + Udf.class.getName());
        }
        if (typeSupplier == null) {
            this.addShareVar(annotationsByType.value(), this.getProvider(udfType));
        } else {
            this.addShareVar(annotationsByType.value(), () -> typeSupplier.get(udfType));
        }
    }

    default public QueryApiBinder loadUdfSource(Class<?> ... udfSourceTypeArrays) {
        return this.loadUdfSource(new HashSet(Arrays.asList(udfSourceTypeArrays)));
    }

    default public QueryApiBinder loadUdfSource(Set<Class<?>> udfSourceTypeSet) {
        return this.loadUdfSource(udfSourceTypeSet, Matchers.anyClass(), null);
    }

    default public QueryApiBinder loadUdfSource(Set<Class<?>> mabyUdfTypeSet, Predicate<Class<?>> matcher, TypeSupplier typeSupplier) {
        if (mabyUdfTypeSet != null && !mabyUdfTypeSet.isEmpty()) {
            mabyUdfTypeSet.stream().filter(matcher).filter(Matchers.annotatedWithClass(DimUdfSource.class)).forEach((? super T aClass) -> this.loadUdfSource((Class<?>)aClass, typeSupplier));
        }
        return this;
    }

    default public void loadUdfSource(Class<?> sourceType, TypeSupplier typeSupplier) {
        Objects.requireNonNull(sourceType, "class is null.");
        int modifier = sourceType.getModifiers();
        if (AsmTools.checkOr((int)modifier, (int[])new int[]{512, 1024}) || sourceType.isArray() || sourceType.isEnum()) {
            throw new IllegalStateException(sourceType.getName() + " must be normal Bean");
        }
        DimUdfSource annotationsByType = sourceType.getAnnotation(DimUdfSource.class);
        if (annotationsByType == null) {
            throw new IllegalStateException(sourceType.getName() + " must be configure @DimUdfSource");
        }
        if (!UdfSource.class.isAssignableFrom(sourceType)) {
            throw new ClassCastException(sourceType.getName() + " is not " + UdfSource.class.getName());
        }
        Class<?> udfSourceType = sourceType;
        HasorUtils.pushStartListener((Environment)this.getEnvironment(), (event, appContext) -> {
            DataQL dataQL = (DataQL)appContext.getInstance(DataQL.class);
            Finder qlFinder = dataQL.getFinder();
            if (typeSupplier == null) {
                dataQL.addShareVar(annotationsByType.value(), () -> ((UdfSource)appContext.getInstance(udfSourceType)).getUdfResource(qlFinder).get());
            } else {
                dataQL.addShareVar(annotationsByType.value(), () -> ((UdfSource)typeSupplier.get(udfSourceType)).getUdfResource(qlFinder).get());
            }
        });
    }

    default public QueryApiBinder addShareVarInstance(String name, Object instance) {
        return this.addShareVar(name, () -> instance);
    }

    default public <T> QueryApiBinder addShareVar(String name, Class<? extends T> implementation) {
        return this.addShareVar(name, () -> this.getProvider(implementation).get());
    }

    default public <T> QueryApiBinder addShareVar(String name, BindInfo<T> bindInfo) {
        return this.addShareVar(name, () -> this.getProvider(bindInfo).get());
    }

    public <T> QueryApiBinder addShareVar(String var1, Supplier<T> var2);

    public QueryApiBinder bindFinder(Supplier<? extends Finder> var1);

    default public QueryApiBinder bindFragment(String fragmentType, FragmentProcess instance) {
        return this.bindFragment(fragmentType, () -> instance);
    }

    default public <T extends FragmentProcess> QueryApiBinder bindFragment(String fragmentType, Class<? extends T> implementation) {
        return this.bindFragment(fragmentType, this.getProvider(implementation));
    }

    default public <T extends FragmentProcess> QueryApiBinder bindFragment(String fragmentType, BindInfo<T> bindInfo) {
        return this.bindFragment(fragmentType, this.getProvider(bindInfo));
    }

    public <T extends FragmentProcess> QueryApiBinder bindFragment(String var1, Supplier<T> var2);
}

