/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.fx.db.runsql.dialect;

import java.util.List;
import java.util.Map;
import net.hasor.dataql.fx.db.fxquery.FxQuery;
import net.hasor.dataql.fx.db.jsqlparser.parser.CCJSqlParserUtil;
import net.hasor.dataql.fx.db.jsqlparser.statement.select.OrderByElement;
import net.hasor.dataql.fx.db.jsqlparser.statement.select.PlainSelect;
import net.hasor.dataql.fx.db.jsqlparser.statement.select.Select;
import net.hasor.dataql.fx.db.runsql.dialect.AbstractDialect;
import net.hasor.dataql.fx.db.runsql.dialect.SqlPageDialect;
import net.hasor.utils.ExceptionUtils;

public class SqlServer2012Dialect
extends AbstractDialect {
    protected Select parseSelect(String buildSqlString, FxQuery fxSql) {
        Select select = fxSql.attach(Select.class);
        if (select == null) {
            try {
                select = (Select)CCJSqlParserUtil.parse(buildSqlString);
                fxSql.attach(Select.class, select);
            }
            catch (Exception e) {
                throw ExceptionUtils.toRuntimeException((Throwable)e);
            }
        }
        return select;
    }

    @Override
    public SqlPageDialect.BoundSql getCountSql(FxQuery fxSql, Map<String, Object> paramMap) {
        Select selectStatement;
        PlainSelect plainSelect;
        String buildSqlString = fxSql.buildQueryString(paramMap);
        List<Object> paramArrays = fxSql.buildParameterSource(paramMap);
        if (buildSqlString.toLowerCase().contains("order by") && (plainSelect = (PlainSelect)(selectStatement = this.parseSelect(buildSqlString, fxSql)).getSelectBody()).getOrderByElements() != null) {
            List<OrderByElement> orderByElements = plainSelect.getOrderByElements();
            plainSelect.setOrderByElements(null);
            buildSqlString = selectStatement.toString();
            plainSelect.setOrderByElements(orderByElements);
        }
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("SELECT COUNT(*) FROM (");
        sqlBuilder.append(buildSqlString);
        sqlBuilder.append(") as TEMP_T");
        return new SqlPageDialect.BoundSql(sqlBuilder.toString(), paramArrays.toArray());
    }

    @Override
    public SqlPageDialect.BoundSql getPageSql(FxQuery fxSql, Map<String, Object> paramMap, int start, int limit) {
        String buildSqlString = fxSql.buildQueryString(paramMap);
        List<Object> paramArrays = fxSql.buildParameterSource(paramMap);
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append(buildSqlString);
        if (buildSqlString.toLowerCase().contains("order by")) {
            Select selectStatement = this.parseSelect(buildSqlString, fxSql);
            PlainSelect plainSelect = (PlainSelect)selectStatement.getSelectBody();
            if (plainSelect.getOrderByElements() == null) {
                sqlBuilder.append(" ORDER BY CURRENT_TIMESTAMP");
            }
        } else {
            sqlBuilder.append(" ORDER BY CURRENT_TIMESTAMP");
        }
        sqlBuilder.append(" offset ? rows fetch next ? rows only ");
        paramArrays.add(start);
        paramArrays.add(limit);
        buildSqlString = sqlBuilder.toString();
        return new SqlPageDialect.BoundSql(buildSqlString, paramArrays.toArray());
    }
}

