/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.fx.db.jsqlparser.util.deparser;

import java.util.Iterator;
import net.hasor.dataql.fx.db.jsqlparser.expression.Expression;
import net.hasor.dataql.fx.db.jsqlparser.expression.ExpressionVisitor;
import net.hasor.dataql.fx.db.jsqlparser.expression.operators.relational.ExpressionList;
import net.hasor.dataql.fx.db.jsqlparser.expression.operators.relational.ItemsListVisitor;
import net.hasor.dataql.fx.db.jsqlparser.expression.operators.relational.MultiExpressionList;
import net.hasor.dataql.fx.db.jsqlparser.expression.operators.relational.NamedExpressionList;
import net.hasor.dataql.fx.db.jsqlparser.schema.Column;
import net.hasor.dataql.fx.db.jsqlparser.statement.replace.Replace;
import net.hasor.dataql.fx.db.jsqlparser.statement.select.SelectVisitor;
import net.hasor.dataql.fx.db.jsqlparser.statement.select.SubSelect;

public class ReplaceDeParser
implements ItemsListVisitor {
    protected StringBuilder buffer;
    private ExpressionVisitor expressionVisitor;
    private SelectVisitor selectVisitor;

    public ReplaceDeParser() {
    }

    public ReplaceDeParser(ExpressionVisitor expressionVisitor, SelectVisitor selectVisitor, StringBuilder buffer) {
        this.buffer = buffer;
        this.expressionVisitor = expressionVisitor;
        this.selectVisitor = selectVisitor;
    }

    public StringBuilder getBuffer() {
        return this.buffer;
    }

    public void setBuffer(StringBuilder buffer) {
        this.buffer = buffer;
    }

    public void deParse(Replace replace) {
        this.buffer.append("REPLACE ");
        if (replace.isUseIntoTables()) {
            this.buffer.append("INTO ");
        }
        this.buffer.append(replace.getTable().getFullyQualifiedName());
        if (replace.getItemsList() != null) {
            if (replace.getColumns() != null) {
                this.buffer.append(" (");
                for (int i = 0; i < replace.getColumns().size(); ++i) {
                    Column column = replace.getColumns().get(i);
                    this.buffer.append(column.getFullyQualifiedName());
                    if (i >= replace.getColumns().size() - 1) continue;
                    this.buffer.append(", ");
                }
                this.buffer.append(") ");
            } else {
                this.buffer.append(" ");
            }
        } else {
            this.buffer.append(" SET ");
            for (int i = 0; i < replace.getColumns().size(); ++i) {
                Column column = replace.getColumns().get(i);
                this.buffer.append(column.getFullyQualifiedName()).append("=");
                Expression expression = replace.getExpressions().get(i);
                expression.accept(this.expressionVisitor);
                if (i >= replace.getColumns().size() - 1) continue;
                this.buffer.append(", ");
            }
        }
        if (replace.getItemsList() != null) {
            replace.getItemsList().accept(this);
        }
    }

    @Override
    public void visit(ExpressionList expressionList) {
        this.buffer.append("VALUES (");
        Iterator<Expression> iter = expressionList.getExpressions().iterator();
        while (iter.hasNext()) {
            Expression expression = iter.next();
            expression.accept(this.expressionVisitor);
            if (!iter.hasNext()) continue;
            this.buffer.append(", ");
        }
        this.buffer.append(")");
    }

    @Override
    public void visit(NamedExpressionList namedExpressionList) {
    }

    @Override
    public void visit(SubSelect subSelect) {
        subSelect.getSelectBody().accept(this.selectVisitor);
    }

    public ExpressionVisitor getExpressionVisitor() {
        return this.expressionVisitor;
    }

    public SelectVisitor getSelectVisitor() {
        return this.selectVisitor;
    }

    public void setExpressionVisitor(ExpressionVisitor visitor) {
        this.expressionVisitor = visitor;
    }

    public void setSelectVisitor(SelectVisitor visitor) {
        this.selectVisitor = visitor;
    }

    @Override
    public void visit(MultiExpressionList multiExprList) {
        this.buffer.append("VALUES ");
        Iterator<ExpressionList> it = multiExprList.getExprList().iterator();
        while (it.hasNext()) {
            this.buffer.append("(");
            Iterator<Expression> iter = it.next().getExpressions().iterator();
            while (iter.hasNext()) {
                Expression expression = iter.next();
                expression.accept(this.expressionVisitor);
                if (!iter.hasNext()) continue;
                this.buffer.append(", ");
            }
            this.buffer.append(")");
            if (!it.hasNext()) continue;
            this.buffer.append(", ");
        }
    }
}

