/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.fx.db.jsqlparser.util.deparser;

import java.util.Iterator;
import java.util.List;
import net.hasor.dataql.fx.db.jsqlparser.expression.ExpressionVisitor;
import net.hasor.dataql.fx.db.jsqlparser.statement.select.OrderByElement;

public class OrderByDeParser {
    protected StringBuilder buffer;
    private ExpressionVisitor expressionVisitor;

    OrderByDeParser() {
    }

    public OrderByDeParser(ExpressionVisitor expressionVisitor, StringBuilder buffer) {
        this.expressionVisitor = expressionVisitor;
        this.buffer = buffer;
    }

    public void deParse(List<OrderByElement> orderByElementList) {
        this.deParse(false, orderByElementList);
    }

    public void deParse(boolean oracleSiblings, List<OrderByElement> orderByElementList) {
        if (oracleSiblings) {
            this.buffer.append(" ORDER SIBLINGS BY ");
        } else {
            this.buffer.append(" ORDER BY ");
        }
        Iterator<OrderByElement> iter = orderByElementList.iterator();
        while (iter.hasNext()) {
            OrderByElement orderByElement = iter.next();
            this.deParseElement(orderByElement);
            if (!iter.hasNext()) continue;
            this.buffer.append(", ");
        }
    }

    public void deParseElement(OrderByElement orderBy) {
        orderBy.getExpression().accept(this.expressionVisitor);
        if (!orderBy.isAsc()) {
            this.buffer.append(" DESC");
        } else if (orderBy.isAscDescPresent()) {
            this.buffer.append(" ASC");
        }
        if (orderBy.getNullOrdering() != null) {
            this.buffer.append(' ');
            this.buffer.append(orderBy.getNullOrdering() == OrderByElement.NullOrdering.NULLS_FIRST ? "NULLS FIRST" : "NULLS LAST");
        }
    }

    void setExpressionVisitor(ExpressionVisitor expressionVisitor) {
        this.expressionVisitor = expressionVisitor;
    }

    void setBuffer(StringBuilder buffer) {
        this.buffer = buffer;
    }
}

