/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.fx.db.jsqlparser.util.deparser;

import java.util.Iterator;
import net.hasor.dataql.fx.db.jsqlparser.expression.Expression;
import net.hasor.dataql.fx.db.jsqlparser.expression.ExpressionVisitor;
import net.hasor.dataql.fx.db.jsqlparser.expression.operators.relational.ExpressionList;
import net.hasor.dataql.fx.db.jsqlparser.statement.select.GroupByElement;

public class GroupByDeParser {
    protected StringBuilder buffer;
    private ExpressionVisitor expressionVisitor;

    GroupByDeParser() {
    }

    public GroupByDeParser(ExpressionVisitor expressionVisitor, StringBuilder buffer) {
        this.expressionVisitor = expressionVisitor;
        this.buffer = buffer;
    }

    public void deParse(GroupByElement groupBy) {
        this.buffer.append("GROUP BY ");
        Iterator<Expression> iter = groupBy.getGroupByExpressions().iterator();
        while (iter.hasNext()) {
            iter.next().accept(this.expressionVisitor);
            if (!iter.hasNext()) continue;
            this.buffer.append(", ");
        }
        if (groupBy.getGroupingSets().size() > 0) {
            this.buffer.append("GROUPING SETS (");
            boolean first = true;
            for (Object o : groupBy.getGroupingSets()) {
                if (first) {
                    first = false;
                } else {
                    this.buffer.append(", ");
                }
                if (o instanceof Expression) {
                    this.buffer.append(o.toString());
                    continue;
                }
                if (!(o instanceof ExpressionList)) continue;
                ExpressionList list = (ExpressionList)o;
                this.buffer.append(list.getExpressions() == null ? "()" : list.toString());
            }
            this.buffer.append(")");
        }
    }

    void setExpressionVisitor(ExpressionVisitor expressionVisitor) {
        this.expressionVisitor = expressionVisitor;
    }

    void setBuffer(StringBuilder buffer) {
        this.buffer = buffer;
    }
}

