/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.fx.db.jsqlparser.util.deparser;

import java.util.stream.Collectors;
import net.hasor.dataql.fx.db.jsqlparser.expression.ExpressionVisitor;
import net.hasor.dataql.fx.db.jsqlparser.expression.ExpressionVisitorAdapter;
import net.hasor.dataql.fx.db.jsqlparser.statement.delete.Delete;
import net.hasor.dataql.fx.db.jsqlparser.statement.select.Join;
import net.hasor.dataql.fx.db.jsqlparser.util.deparser.LimitDeparser;
import net.hasor.dataql.fx.db.jsqlparser.util.deparser.OrderByDeParser;

public class DeleteDeParser {
    protected StringBuilder buffer = new StringBuilder();
    private ExpressionVisitor expressionVisitor = new ExpressionVisitorAdapter();

    public DeleteDeParser() {
    }

    public DeleteDeParser(ExpressionVisitor expressionVisitor, StringBuilder buffer) {
        this.buffer = buffer;
        this.expressionVisitor = expressionVisitor;
    }

    public StringBuilder getBuffer() {
        return this.buffer;
    }

    public void setBuffer(StringBuilder buffer) {
        this.buffer = buffer;
    }

    public void deParse(Delete delete) {
        this.buffer.append("DELETE");
        if (delete.getTables() != null && delete.getTables().size() > 0) {
            this.buffer.append(delete.getTables().stream().map(t -> t.getFullyQualifiedName()).collect(Collectors.joining(", ", " ", "")));
        }
        this.buffer.append(" FROM ").append(delete.getTable().toString());
        if (delete.getJoins() != null) {
            for (Join join : delete.getJoins()) {
                if (join.isSimple()) {
                    this.buffer.append(", ").append(join);
                    continue;
                }
                this.buffer.append(" ").append(join);
            }
        }
        if (delete.getWhere() != null) {
            this.buffer.append(" WHERE ");
            delete.getWhere().accept(this.expressionVisitor);
        }
        if (delete.getOrderByElements() != null) {
            new OrderByDeParser(this.expressionVisitor, this.buffer).deParse(delete.getOrderByElements());
        }
        if (delete.getLimit() != null) {
            new LimitDeparser(this.buffer).deParse(delete.getLimit());
        }
    }

    public ExpressionVisitor getExpressionVisitor() {
        return this.expressionVisitor;
    }

    public void setExpressionVisitor(ExpressionVisitor visitor) {
        this.expressionVisitor = visitor;
    }
}

