/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.fx.db.jsqlparser.util.deparser;

import net.hasor.dataql.fx.db.jsqlparser.expression.ExpressionVisitor;
import net.hasor.dataql.fx.db.jsqlparser.statement.DeclareStatement;
import net.hasor.dataql.fx.db.jsqlparser.statement.DeclareType;

public class DeclareStatementDeParser {
    protected StringBuilder buffer;
    private ExpressionVisitor expressionVisitor;

    public DeclareStatementDeParser(ExpressionVisitor expressionVisitor, StringBuilder buffer) {
        this.buffer = buffer;
        this.expressionVisitor = expressionVisitor;
    }

    public StringBuilder getBuffer() {
        return this.buffer;
    }

    public void setBuffer(StringBuilder buffer) {
        this.buffer = buffer;
    }

    public void deParse(DeclareStatement declare) {
        this.buffer.append("DECLARE ");
        if (declare.getUserVariable() != null) {
            declare.getUserVariable().accept(this.expressionVisitor);
        }
        if (declare.getType() == DeclareType.AS) {
            this.buffer.append(" AS ");
            this.buffer.append(declare.getTypeName());
            return;
        }
        if (declare.getType() == DeclareType.TABLE) {
            this.buffer.append(" TABLE (");
            for (int i = 0; i < declare.getColumnDefinitions().size(); ++i) {
                if (i > 0) {
                    this.buffer.append(", ");
                }
                this.buffer.append(declare.getColumnDefinitions().get(i).toString());
            }
            this.buffer.append(")");
        } else if (declare.getTypeDefinitions() != null) {
            for (int i = 0; i < declare.getTypeDefinitions().size(); ++i) {
                if (i > 0) {
                    this.buffer.append(", ");
                }
                DeclareStatement.TypeDefExpr type = declare.getTypeDefinitions().get(i);
                if (type.userVariable != null) {
                    type.userVariable.accept(this.expressionVisitor);
                    this.buffer.append(" ");
                }
                this.buffer.append(type.colDataType.toString());
                if (type.defaultExpr == null) continue;
                this.buffer.append(" = ");
                type.defaultExpr.accept(this.expressionVisitor);
            }
        }
    }

    public ExpressionVisitor getExpressionVisitor() {
        return this.expressionVisitor;
    }

    public void setExpressionVisitor(ExpressionVisitor visitor) {
        this.expressionVisitor = visitor;
    }
}

