/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.fx.db.jsqlparser.util.deparser;

import java.util.Iterator;
import net.hasor.dataql.fx.db.jsqlparser.statement.create.index.CreateIndex;
import net.hasor.dataql.fx.db.jsqlparser.statement.create.table.Index;

public class CreateIndexDeParser {
    protected StringBuilder buffer;

    public CreateIndexDeParser(StringBuilder buffer) {
        this.buffer = buffer;
    }

    public void deParse(CreateIndex createIndex) {
        Index index = createIndex.getIndex();
        this.buffer.append("CREATE ");
        if (index.getType() != null) {
            this.buffer.append(index.getType());
            this.buffer.append(" ");
        }
        this.buffer.append("INDEX ");
        this.buffer.append(index.getName());
        this.buffer.append(" ON ");
        this.buffer.append(createIndex.getTable().getFullyQualifiedName());
        String using = index.getUsing();
        if (using != null) {
            this.buffer.append(" USING ");
            this.buffer.append(using);
        }
        if (index.getColumnsNames() != null) {
            this.buffer.append(" (");
            Iterator<String> iter = index.getColumnsNames().iterator();
            while (iter.hasNext()) {
                String columnName = iter.next();
                this.buffer.append(columnName);
                if (!iter.hasNext()) continue;
                this.buffer.append(", ");
            }
            this.buffer.append(")");
        }
    }

    public StringBuilder getBuffer() {
        return this.buffer;
    }

    public void setBuffer(StringBuilder buffer) {
        this.buffer = buffer;
    }
}

