/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.fx.db.jsqlparser.statement.update;

import java.util.List;
import net.hasor.dataql.fx.db.jsqlparser.expression.Expression;
import net.hasor.dataql.fx.db.jsqlparser.schema.Column;
import net.hasor.dataql.fx.db.jsqlparser.schema.Table;
import net.hasor.dataql.fx.db.jsqlparser.statement.Statement;
import net.hasor.dataql.fx.db.jsqlparser.statement.StatementVisitor;
import net.hasor.dataql.fx.db.jsqlparser.statement.select.FromItem;
import net.hasor.dataql.fx.db.jsqlparser.statement.select.Join;
import net.hasor.dataql.fx.db.jsqlparser.statement.select.Limit;
import net.hasor.dataql.fx.db.jsqlparser.statement.select.OrderByElement;
import net.hasor.dataql.fx.db.jsqlparser.statement.select.PlainSelect;
import net.hasor.dataql.fx.db.jsqlparser.statement.select.Select;
import net.hasor.dataql.fx.db.jsqlparser.statement.select.SelectExpressionItem;

public class Update
implements Statement {
    private Table table;
    private Expression where;
    private List<Column> columns;
    private List<Expression> expressions;
    private FromItem fromItem;
    private List<Join> joins;
    private List<Join> startJoins;
    private Select select;
    private boolean useColumnsBrackets = true;
    private boolean useSelect = false;
    private List<OrderByElement> orderByElements;
    private Limit limit;
    private boolean returningAllColumns = false;
    private List<SelectExpressionItem> returningExpressionList = null;

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public Table getTable() {
        return this.table;
    }

    public Expression getWhere() {
        return this.where;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void setWhere(Expression expression) {
        this.where = expression;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public List<Expression> getExpressions() {
        return this.expressions;
    }

    public void setColumns(List<Column> list) {
        this.columns = list;
    }

    public void setExpressions(List<Expression> list) {
        this.expressions = list;
    }

    public FromItem getFromItem() {
        return this.fromItem;
    }

    public void setFromItem(FromItem fromItem) {
        this.fromItem = fromItem;
    }

    public List<Join> getJoins() {
        return this.joins;
    }

    public void setJoins(List<Join> joins) {
        this.joins = joins;
    }

    public List<Join> getStartJoins() {
        return this.startJoins;
    }

    public void setStartJoins(List<Join> startJoins) {
        this.startJoins = startJoins;
    }

    public Select getSelect() {
        return this.select;
    }

    public void setSelect(Select select) {
        this.select = select;
    }

    public boolean isUseColumnsBrackets() {
        return this.useColumnsBrackets;
    }

    public void setUseColumnsBrackets(boolean useColumnsBrackets) {
        this.useColumnsBrackets = useColumnsBrackets;
    }

    public boolean isUseSelect() {
        return this.useSelect;
    }

    public void setUseSelect(boolean useSelect) {
        this.useSelect = useSelect;
    }

    public void setOrderByElements(List<OrderByElement> orderByElements) {
        this.orderByElements = orderByElements;
    }

    public void setLimit(Limit limit) {
        this.limit = limit;
    }

    public List<OrderByElement> getOrderByElements() {
        return this.orderByElements;
    }

    public Limit getLimit() {
        return this.limit;
    }

    public boolean isReturningAllColumns() {
        return this.returningAllColumns;
    }

    public void setReturningAllColumns(boolean returningAllColumns) {
        this.returningAllColumns = returningAllColumns;
    }

    public List<SelectExpressionItem> getReturningExpressionList() {
        return this.returningExpressionList;
    }

    public void setReturningExpressionList(List<SelectExpressionItem> returningExpressionList) {
        this.returningExpressionList = returningExpressionList;
    }

    public String toString() {
        int i;
        StringBuilder b = new StringBuilder("UPDATE ");
        b.append(this.table);
        if (this.startJoins != null) {
            for (Join join : this.startJoins) {
                if (join.isSimple()) {
                    b.append(", ").append(join);
                    continue;
                }
                b.append(" ").append(join);
            }
        }
        b.append(" SET ");
        if (!this.useSelect) {
            for (i = 0; i < this.getColumns().size(); ++i) {
                if (i != 0) {
                    b.append(", ");
                }
                b.append(this.columns.get(i)).append(" = ");
                b.append(this.expressions.get(i));
            }
        } else {
            if (this.useColumnsBrackets) {
                b.append("(");
            }
            for (i = 0; i < this.getColumns().size(); ++i) {
                if (i != 0) {
                    b.append(", ");
                }
                b.append(this.columns.get(i));
            }
            if (this.useColumnsBrackets) {
                b.append(")");
            }
            b.append(" = ");
            b.append("(").append(this.select).append(")");
        }
        if (this.fromItem != null) {
            b.append(" FROM ").append(this.fromItem);
            if (this.joins != null) {
                for (Join join : this.joins) {
                    if (join.isSimple()) {
                        b.append(", ").append(join);
                        continue;
                    }
                    b.append(" ").append(join);
                }
            }
        }
        if (this.where != null) {
            b.append(" WHERE ");
            b.append(this.where);
        }
        if (this.orderByElements != null) {
            b.append(PlainSelect.orderByToString(this.orderByElements));
        }
        if (this.limit != null) {
            b.append(this.limit);
        }
        if (this.isReturningAllColumns()) {
            b.append(" RETURNING *");
        } else if (this.getReturningExpressionList() != null) {
            b.append(" RETURNING ").append(PlainSelect.getStringList(this.getReturningExpressionList(), true, false));
        }
        return b.toString();
    }
}

