/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.fx.db.jsqlparser.statement.execute;

import java.util.List;
import net.hasor.dataql.fx.db.jsqlparser.expression.operators.relational.ExpressionList;
import net.hasor.dataql.fx.db.jsqlparser.statement.Statement;
import net.hasor.dataql.fx.db.jsqlparser.statement.StatementVisitor;
import net.hasor.dataql.fx.db.jsqlparser.statement.select.PlainSelect;

public class Execute
implements Statement {
    private EXEC_TYPE execType = EXEC_TYPE.EXECUTE;
    private String name;
    private ExpressionList exprList;
    private boolean parenthesis = false;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setName(List<String> names) {
        for (String item : names) {
            if (this.name != null) {
                this.name = this.name + "." + item;
                continue;
            }
            this.name = item;
        }
    }

    public ExpressionList getExprList() {
        return this.exprList;
    }

    public void setExprList(ExpressionList exprList) {
        this.exprList = exprList;
    }

    public EXEC_TYPE getExecType() {
        return this.execType;
    }

    public void setExecType(EXEC_TYPE execType) {
        this.execType = execType;
    }

    public boolean isParenthesis() {
        return this.parenthesis;
    }

    public void setParenthesis(boolean parenthesis) {
        this.parenthesis = parenthesis;
    }

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public String toString() {
        return this.execType.name() + " " + this.name + (this.exprList != null && this.exprList.getExpressions() != null ? " " + PlainSelect.getStringList(this.exprList.getExpressions(), true, this.parenthesis) : "");
    }

    public static enum EXEC_TYPE {
        EXECUTE,
        EXEC,
        CALL;

    }
}

