/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.fx.db.jsqlparser.schema;

import java.util.List;
import net.hasor.dataql.fx.db.jsqlparser.expression.Expression;
import net.hasor.dataql.fx.db.jsqlparser.expression.ExpressionVisitor;
import net.hasor.dataql.fx.db.jsqlparser.parser.ASTNodeAccessImpl;
import net.hasor.dataql.fx.db.jsqlparser.schema.MultiPartName;
import net.hasor.dataql.fx.db.jsqlparser.schema.Table;

public final class Column
extends ASTNodeAccessImpl
implements Expression,
MultiPartName {
    private Table table;
    private String columnName;

    public Column() {
    }

    public Column(Table table, String columnName) {
        this.setTable(table);
        this.setColumnName(columnName);
    }

    public Column(List<String> nameParts) {
        this(nameParts.size() > 1 ? new Table(nameParts.subList(0, nameParts.size() - 1)) : null, nameParts.get(nameParts.size() - 1));
    }

    public Column(String columnName) {
        this(null, columnName);
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String string) {
        this.columnName = string;
    }

    @Override
    public String getFullyQualifiedName() {
        return this.getName(false);
    }

    public String getName(boolean aliases) {
        StringBuilder fqn = new StringBuilder();
        if (this.table != null) {
            if (this.table.getAlias() != null && aliases) {
                fqn.append(this.table.getAlias().getName());
            } else {
                fqn.append(this.table.getFullyQualifiedName());
            }
        }
        if (fqn.length() > 0) {
            fqn.append('.');
        }
        if (this.columnName != null) {
            fqn.append(this.columnName);
        }
        return fqn.toString();
    }

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    public String toString() {
        return this.getName(true);
    }
}

