/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.fx.db.jsqlparser.expression.operators.relational;

import net.hasor.dataql.fx.db.jsqlparser.expression.Expression;
import net.hasor.dataql.fx.db.jsqlparser.expression.ExpressionVisitor;
import net.hasor.dataql.fx.db.jsqlparser.expression.operators.relational.ItemsList;
import net.hasor.dataql.fx.db.jsqlparser.expression.operators.relational.SupportsOldOracleJoinSyntax;
import net.hasor.dataql.fx.db.jsqlparser.parser.ASTNodeAccessImpl;

public class InExpression
extends ASTNodeAccessImpl
implements Expression,
SupportsOldOracleJoinSyntax {
    private Expression leftExpression;
    private ItemsList leftItemsList;
    private ItemsList rightItemsList;
    private boolean not = false;
    private int oldOracleJoinSyntax = 0;

    public InExpression() {
    }

    public InExpression(Expression leftExpression, ItemsList itemsList) {
        this.setLeftExpression(leftExpression);
        this.setRightItemsList(itemsList);
    }

    @Override
    public void setOldOracleJoinSyntax(int oldOracleJoinSyntax) {
        this.oldOracleJoinSyntax = oldOracleJoinSyntax;
        if (oldOracleJoinSyntax < 0 || oldOracleJoinSyntax > 1) {
            throw new IllegalArgumentException("unexpected join type for oracle found with IN (type=" + oldOracleJoinSyntax + ")");
        }
    }

    @Override
    public int getOldOracleJoinSyntax() {
        return this.oldOracleJoinSyntax;
    }

    public ItemsList getRightItemsList() {
        return this.rightItemsList;
    }

    public Expression getLeftExpression() {
        return this.leftExpression;
    }

    public final void setRightItemsList(ItemsList list) {
        this.rightItemsList = list;
    }

    public final void setLeftExpression(Expression expression) {
        this.leftExpression = expression;
    }

    public boolean isNot() {
        return this.not;
    }

    public void setNot(boolean b) {
        this.not = b;
    }

    public ItemsList getLeftItemsList() {
        return this.leftItemsList;
    }

    public void setLeftItemsList(ItemsList leftItemsList) {
        this.leftItemsList = leftItemsList;
    }

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    private String getLeftExpressionString() {
        return this.leftExpression + (this.oldOracleJoinSyntax == 1 ? "(+)" : "");
    }

    public String toString() {
        return (this.leftExpression == null ? this.leftItemsList : this.getLeftExpressionString()) + " " + (this.not ? "NOT " : "") + "IN " + this.rightItemsList + "";
    }

    @Override
    public int getOraclePriorPosition() {
        return 0;
    }

    @Override
    public void setOraclePriorPosition(int priorPosition) {
        if (priorPosition != 0) {
            throw new IllegalArgumentException("unexpected prior for oracle found");
        }
    }
}

