/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.fx.db.jsqlparser.expression;

import java.util.List;
import net.hasor.dataql.fx.db.jsqlparser.expression.AnalyticType;
import net.hasor.dataql.fx.db.jsqlparser.expression.Expression;
import net.hasor.dataql.fx.db.jsqlparser.expression.ExpressionVisitor;
import net.hasor.dataql.fx.db.jsqlparser.expression.Function;
import net.hasor.dataql.fx.db.jsqlparser.expression.KeepExpression;
import net.hasor.dataql.fx.db.jsqlparser.expression.OrderByClause;
import net.hasor.dataql.fx.db.jsqlparser.expression.PartitionByClause;
import net.hasor.dataql.fx.db.jsqlparser.expression.WindowElement;
import net.hasor.dataql.fx.db.jsqlparser.expression.operators.relational.ExpressionList;
import net.hasor.dataql.fx.db.jsqlparser.parser.ASTNodeAccessImpl;
import net.hasor.dataql.fx.db.jsqlparser.statement.select.OrderByElement;

public class AnalyticExpression
extends ASTNodeAccessImpl
implements Expression {
    private final OrderByClause orderBy = new OrderByClause();
    private final PartitionByClause partitionBy = new PartitionByClause();
    private String name;
    private Expression expression;
    private Expression offset;
    private Expression defaultValue;
    private boolean allColumns = false;
    private KeepExpression keep = null;
    private AnalyticType type = AnalyticType.OVER;
    private boolean distinct = false;
    private boolean ignoreNulls = false;
    private Expression filterExpression = null;
    private WindowElement windowElement = null;

    public AnalyticExpression() {
    }

    public AnalyticExpression(Function function) {
        this.name = function.getName();
        this.allColumns = function.isAllColumns();
        this.distinct = function.isDistinct();
        ExpressionList list = function.getParameters();
        if (list != null) {
            if (list.getExpressions().size() > 3) {
                throw new IllegalArgumentException("function object not valid to initialize analytic expression");
            }
            this.expression = list.getExpressions().get(0);
            if (list.getExpressions().size() > 1) {
                this.offset = list.getExpressions().get(1);
            }
            if (list.getExpressions().size() > 2) {
                this.defaultValue = list.getExpressions().get(2);
            }
        }
        this.ignoreNulls = function.isIgnoreNulls();
        this.keep = function.getKeep();
    }

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    public List<OrderByElement> getOrderByElements() {
        return this.orderBy.getOrderByElements();
    }

    public void setOrderByElements(List<OrderByElement> orderByElements) {
        this.orderBy.setOrderByElements(orderByElements);
    }

    public KeepExpression getKeep() {
        return this.keep;
    }

    public void setKeep(KeepExpression keep) {
        this.keep = keep;
    }

    public ExpressionList getPartitionExpressionList() {
        return this.partitionBy.getPartitionExpressionList();
    }

    public void setPartitionExpressionList(ExpressionList partitionExpressionList) {
        this.setPartitionExpressionList(partitionExpressionList, false);
    }

    public void setPartitionExpressionList(ExpressionList partitionExpressionList, boolean brackets) {
        this.partitionBy.setPartitionExpressionList(partitionExpressionList, brackets);
    }

    public boolean isPartitionByBrackets() {
        return this.partitionBy.isBrackets();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public Expression getOffset() {
        return this.offset;
    }

    public void setOffset(Expression offset) {
        this.offset = offset;
    }

    public Expression getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Expression defaultValue) {
        this.defaultValue = defaultValue;
    }

    public WindowElement getWindowElement() {
        return this.windowElement;
    }

    public void setWindowElement(WindowElement windowElement) {
        this.windowElement = windowElement;
    }

    public AnalyticType getType() {
        return this.type;
    }

    public void setType(AnalyticType type) {
        this.type = type;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public boolean isIgnoreNulls() {
        return this.ignoreNulls;
    }

    public void setIgnoreNulls(boolean ignoreNulls) {
        this.ignoreNulls = ignoreNulls;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.name).append("(");
        if (this.isDistinct()) {
            b.append("DISTINCT ");
        }
        if (this.expression != null) {
            b.append(this.expression.toString());
            if (this.offset != null) {
                b.append(", ").append(this.offset.toString());
                if (this.defaultValue != null) {
                    b.append(", ").append(this.defaultValue.toString());
                }
            }
        } else if (this.isAllColumns()) {
            b.append("*");
        }
        if (this.isIgnoreNulls()) {
            b.append(" IGNORE NULLS");
        }
        b.append(") ");
        if (this.keep != null) {
            b.append(this.keep.toString()).append(" ");
        }
        if (this.filterExpression != null) {
            b.append("FILTER (WHERE ");
            b.append(this.filterExpression.toString());
            b.append(") ");
        }
        switch (this.type) {
            case WITHIN_GROUP: {
                b.append("WITHIN GROUP");
                break;
            }
            default: {
                b.append("OVER");
            }
        }
        b.append(" (");
        this.partitionBy.toStringPartitionBy(b);
        this.orderBy.toStringOrderByElements(b);
        if (this.windowElement != null) {
            if (this.orderBy != null && this.orderBy.getOrderByElements() != null) {
                b.append(' ');
            }
            b.append(this.windowElement);
        }
        b.append(")");
        return b.toString();
    }

    public boolean isAllColumns() {
        return this.allColumns;
    }

    public void setAllColumns(boolean allColumns) {
        this.allColumns = allColumns;
    }

    public Expression getFilterExpression() {
        return this.filterExpression;
    }

    public void setFilterExpression(Expression filterExpression) {
        this.filterExpression = filterExpression;
    }
}

