/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataql.fx.db.fxquery;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.hasor.dataql.fx.db.fxquery.DefaultMemberAccess;
import net.hasor.dataql.fx.db.fxquery.FxQuery;
import net.hasor.dataql.fx.db.fxquery.GenericTokenParser;
import net.hasor.dataql.fx.db.ognl.Ognl;
import net.hasor.dataql.fx.db.ognl.OgnlContext;
import net.hasor.utils.ExceptionUtils;
import net.hasor.utils.StringUtils;

public class DefaultFxQuery
extends HashMap<Class<?>, Object>
implements Cloneable,
FxQuery {
    private final StringBuilder queryStringOri = new StringBuilder("");
    private final List<Object> queryStringPlan = new LinkedList<Object>();
    private final List<String> paramEl = new LinkedList<String>();
    private boolean havePlaceholder = false;
    private final AtomicReference<Object> tempObject = new AtomicReference();
    private final Supplier<Object> objectSupplier = this.tempObject::get;

    public void insertString(String append) {
        this.queryStringOri.insert(0, append);
        this.queryStringPlan.add(0, append);
    }

    public void appendString(String append) {
        Object ss;
        this.queryStringOri.append(append);
        if (!this.queryStringPlan.isEmpty() && (ss = this.queryStringPlan.get(this.queryStringPlan.size() - 1)) instanceof StringBuilder) {
            ((StringBuilder)ss).append(append);
            return;
        }
        this.queryStringPlan.add(new StringBuilder(append));
    }

    public void insertValueExpr(String exprString) {
        this.queryStringOri.insert(0, "#{" + exprString + "}");
        this.queryStringPlan.add("?");
        this.paramEl.add(exprString);
    }

    public void appendValueExpr(String exprString) {
        this.queryStringOri.append("#{" + exprString + "}");
        this.queryStringPlan.add("?");
        this.paramEl.add(exprString);
    }

    public void insertPlaceholderExpr(String exprString) {
        this.queryStringOri.insert(0, "${" + exprString + "}");
        this.queryStringPlan.add(0, new EvalCharSequence(exprString, this.objectSupplier));
        this.havePlaceholder = true;
    }

    public void appendPlaceholderExpr(String exprString) {
        this.queryStringOri.append("${" + exprString + "}");
        this.queryStringPlan.add(new EvalCharSequence(exprString, this.objectSupplier));
        this.havePlaceholder = true;
    }

    @Override
    public boolean isHavePlaceholder() {
        return this.havePlaceholder;
    }

    public StringBuilder getOriSqlString() {
        return this.queryStringOri;
    }

    @Override
    public String buildQueryString(Object context) {
        try {
            this.tempObject.set(context);
            String string = StringUtils.join((Object[])this.queryStringPlan.toArray());
            return string;
        }
        finally {
            this.tempObject.set(null);
        }
    }

    @Override
    public List<Object> buildParameterSource(Object context) {
        return this.paramEl.stream().map(exprString -> DefaultFxQuery.evalOgnl(exprString, context)).collect(Collectors.toList());
    }

    @Override
    public <T> T attach(Class<? extends T> attach, T attachValue) {
        return super.put(attach, attachValue);
    }

    @Override
    public <T> T attach(Class<? extends T> attach) {
        return (T)super.get(attach);
    }

    public static Object evalOgnl(String exprString, Object root) {
        try {
            OgnlContext context = new OgnlContext(null, null, new DefaultMemberAccess(true));
            return Ognl.getValue(exprString, (Map)context, root);
        }
        catch (Exception e) {
            throw ExceptionUtils.toRuntimeException((Throwable)e);
        }
    }

    public static FxQuery analysisSQL(String fragmentString) {
        DefaultFxQuery fxSql = new DefaultFxQuery();
        String result = new GenericTokenParser(new String[]{"#{", "${"}, "}", (builder, token, content) -> {
            fxSql.appendString(builder.toString());
            if (token.equalsIgnoreCase("${")) {
                fxSql.appendPlaceholderExpr(content);
            }
            if (token.equalsIgnoreCase("#{")) {
                fxSql.appendValueExpr(content);
            }
            builder.delete(0, builder.length());
            return "";
        }).parse(fragmentString);
        fxSql.appendString(result);
        return fxSql;
    }

    @Override
    public FxQuery clone() {
        return DefaultFxQuery.analysisSQL(this.queryStringOri.toString());
    }

    private static class EvalCharSequence {
        private final String exprString;
        private final Supplier<Object> exprContext;

        public EvalCharSequence(String exprString, Supplier<Object> exprContext) {
            this.exprString = exprString;
            this.exprContext = exprContext;
        }

        public String toString() {
            return String.valueOf(DefaultFxQuery.evalOgnl(this.exprString, this.exprContext.get()));
        }
    }
}

