/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.sms.aliyun;

import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsRequest;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsResponse;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import net.guerlab.sms.aliyun.AliyunProperties;
import net.guerlab.sms.core.domain.NoticeData;
import net.guerlab.sms.core.exception.SendFailedException;
import net.guerlab.sms.core.utils.StringUtils;
import net.guerlab.sms.server.handler.AbstractSendHandler;
import net.guerlab.sms.server.properties.AbstractHandlerProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;

public class AliyunSendHandler
extends AbstractSendHandler<AliyunProperties> {
    private static final Logger log = LoggerFactory.getLogger(AliyunSendHandler.class);
    private static final String OK = "OK";
    private static final String PRODUCT = "Dysmsapi";
    private static final String DOMAIN = "dysmsapi.aliyuncs.com";
    private final ObjectMapper objectMapper;
    private final IAcsClient acsClient;

    public AliyunSendHandler(AliyunProperties properties, ApplicationEventPublisher eventPublisher, ObjectMapper objectMapper) {
        super((AbstractHandlerProperties)properties, eventPublisher);
        this.objectMapper = objectMapper;
        String endPoint = properties.getEndpoint();
        String accessKeyId = properties.getAccessKeyId();
        String accessKeySecret = properties.getAccessKeySecret();
        DefaultProfile profile = DefaultProfile.getProfile((String)endPoint, (String)accessKeyId, (String)accessKeySecret);
        DefaultProfile.addEndpoint((String)endPoint, (String)PRODUCT, (String)DOMAIN);
        this.acsClient = new DefaultAcsClient((IClientProfile)profile);
    }

    public boolean send(NoticeData noticeData, Collection<String> phones) {
        String paramString;
        try {
            paramString = this.objectMapper.writeValueAsString((Object)noticeData.getParams());
        }
        catch (Exception e) {
            log.debug(e.getMessage(), (Throwable)e);
            this.publishSendFailEvent(noticeData, phones, e);
            return false;
        }
        SendSmsRequest request = new SendSmsRequest();
        request.setSysMethod(MethodType.POST);
        request.setPhoneNumbers(StringUtils.join(phones, (String)","));
        request.setSignName(((AliyunProperties)this.properties).getSignName());
        request.setTemplateCode((String)((AliyunProperties)this.properties).getTemplates(noticeData.getType()));
        request.setTemplateParam(paramString);
        try {
            SendSmsResponse sendSmsResponse = (SendSmsResponse)this.acsClient.getAcsResponse((AcsRequest)request);
            if (OK.equals(sendSmsResponse.getCode())) {
                this.publishSendSuccessEvent(noticeData, phones);
                return true;
            }
            log.debug("send fail[code={}, message={}]", (Object)sendSmsResponse.getCode(), (Object)sendSmsResponse.getMessage());
            this.publishSendFailEvent(noticeData, phones, (Throwable)new SendFailedException(sendSmsResponse.getMessage()));
        }
        catch (Exception e) {
            log.debug(e.getMessage(), (Throwable)e);
            this.publishSendFailEvent(noticeData, phones, e);
        }
        return false;
    }

    public String getChannelName() {
        return "aliyun";
    }
}

