/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.cloud.core.util;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.lang.Nullable;

@Configuration
public class SpringUtils
implements ApplicationContextAware {
    private static ApplicationContext context = null;

    public static ApplicationContext getContext() {
        return context;
    }

    public static <T> Collection<T> getBeans(Class<T> clazz) {
        return SpringUtils.getContext().getBeansOfType(clazz).values();
    }

    public static <T> T getBean(Class<T> clazz) {
        return (T)SpringUtils.getContext().getBean(clazz);
    }

    public static Map<String, Object> getBeanMapWithAnnotation(Class<? extends Annotation> annotationType) {
        return SpringUtils.getContext().getBeansWithAnnotation(annotationType);
    }

    public static <T> Map<String, T> getBeanMapWithAnnotation(Class<T> clazz, Class<? extends Annotation> annotationType) {
        Map<String, Object> beanMap = SpringUtils.getBeanMapWithAnnotation(annotationType);
        if (beanMap.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> result = new HashMap<String, Object>(beanMap.size());
        for (Map.Entry<String, Object> entry : beanMap.entrySet()) {
            String beanName = entry.getKey();
            Object bean = entry.getValue();
            if (!clazz.isInstance(bean)) continue;
            result.put(beanName, bean);
        }
        return result;
    }

    public static Collection<Object> getBeansWithAnnotation(Class<? extends Annotation> annotationType) {
        return SpringUtils.getBeanMapWithAnnotation(annotationType).values();
    }

    public static <T> Collection<T> getBeansWithAnnotation(Class<T> clazz, Class<? extends Annotation> annotationType) {
        return SpringUtils.getBeanMapWithAnnotation(clazz, annotationType).values();
    }

    public static <T> Map<String, T> getBeanMap(Class<T> clazz) {
        return context.getBeansOfType(clazz);
    }

    private static Environment getEnvironment() {
        return SpringUtils.getContext().getEnvironment();
    }

    @Nullable
    public static String getProperty(String propertyName) {
        return SpringUtils.getEnvironment().getProperty(propertyName);
    }

    public static String getApplicationName() {
        String name = SpringUtils.getProperty("spring.application.name");
        return name == null ? "" : name;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        context = applicationContext;
    }
}

