/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.cloud.core.sequence;

import net.guerlab.cloud.core.sequence.SystemClock;
import net.guerlab.commons.exception.ApplicationException;

public class Sequence {
    private static final long START_TIME = 1519740777809L;
    private static final long WORKER_ID_BITS = 5L;
    private static final long DATA_CENTER_ID_BITS = 5L;
    private static final long SEQUENCE_BITS = 12L;
    private static final long MAX_WORKER_ID = 31L;
    private static final long MAX_DATA_CENTER_ID = 31L;
    private static final long WORKER_ID_SHIFT = 12L;
    private static final long DATA_CENTER_ID_SHIFT = 17L;
    private static final long TIMESTAMP_LEFT_SHIFT = 22L;
    private static final long SEQUENCE_MASK = 4095L;
    private final long workerId;
    private final long dataCenterId;
    private long nowSequence = 0L;
    private long lastTimestamp = -1L;
    private boolean isClock = false;

    public Sequence(long workerId, long dataCenterId) {
        if (workerId > 31L || workerId < 0L) {
            throw new IllegalArgumentException(String.format("worker Id can't be greater than %d or less than 0", 31L));
        }
        if (dataCenterId > 31L || dataCenterId < 0L) {
            throw new IllegalArgumentException(String.format("dataCenter Id can't be greater than %d or less than 0", 31L));
        }
        this.workerId = workerId;
        this.dataCenterId = dataCenterId;
    }

    public void setClock(boolean clock) {
        this.isClock = clock;
    }

    public synchronized Long nextId() {
        long timestamp = this.timeGen();
        if (timestamp < this.lastTimestamp) {
            long offset = this.lastTimestamp - timestamp;
            if (offset > 5L) {
                throw new ApplicationException(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", offset));
            }
            try {
                this.wait(offset << 1);
                timestamp = this.timeGen();
                if (timestamp < this.lastTimestamp) {
                    throw new ApplicationException(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", offset));
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new ApplicationException(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        if (this.lastTimestamp == timestamp) {
            this.nowSequence = this.nowSequence + 1L & 0xFFFL;
            if (this.nowSequence == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.nowSequence = 0L;
        }
        this.lastTimestamp = timestamp;
        return timestamp - 1519740777809L << 22 | this.dataCenterId << 17 | this.workerId << 12 | this.nowSequence;
    }

    private long tilNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    private long timeGen() {
        if (this.isClock) {
            return SystemClock.now();
        }
        return System.currentTimeMillis();
    }
}

