/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.cloud.core.result;

import java.util.ArrayList;
import java.util.List;
import net.guerlab.cloud.core.result.ApplicationStackTrace;
import org.springframework.lang.Nullable;

public class Result<T> {
    protected boolean status;
    protected String message;
    protected T data;
    protected int errorCode;
    protected String errorDetail;
    protected List<ApplicationStackTrace> stackTraces = new ArrayList<ApplicationStackTrace>();

    public Result() {
        this(null, null);
    }

    public Result(@Nullable String message) {
        this(false, message, null);
    }

    public Result(@Nullable String message, @Nullable T data) {
        this(false, message, data);
    }

    public Result(@Nullable String message, int errorCode) {
        this(false, message, null, errorCode);
    }

    public Result(boolean status, @Nullable String message, @Nullable T data) {
        this(status, message, data, 0);
    }

    public Result(boolean status, @Nullable String message, @Nullable T data, int errorCode) {
        this.status = status;
        this.message = message;
        this.data = data;
        this.errorCode = errorCode;
    }

    public Result<T> addStackTraces(@Nullable List<ApplicationStackTrace> stackTraces) {
        if (stackTraces != null && this.stackTraces != null) {
            this.stackTraces.addAll(stackTraces);
        }
        return this;
    }

    public Result<T> addStackTraces(@Nullable ApplicationStackTrace stackTrace) {
        if (stackTrace != null && this.stackTraces != null) {
            this.stackTraces.add(stackTrace);
        }
        return this;
    }

    public boolean isStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public T getData() {
        return this.data;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getErrorDetail() {
        return this.errorDetail;
    }

    public List<ApplicationStackTrace> getStackTraces() {
        return this.stackTraces;
    }

    public void setStatus(boolean status) {
        this.status = status;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setData(T data) {
        this.data = data;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public void setErrorDetail(String errorDetail) {
        this.errorDetail = errorDetail;
    }

    public void setStackTraces(List<ApplicationStackTrace> stackTraces) {
        this.stackTraces = stackTraces;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Result)) {
            return false;
        }
        Result other = (Result)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isStatus() != other.isStatus()) {
            return false;
        }
        if (this.getErrorCode() != other.getErrorCode()) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        String this$errorDetail = this.getErrorDetail();
        String other$errorDetail = other.getErrorDetail();
        if (this$errorDetail == null ? other$errorDetail != null : !this$errorDetail.equals(other$errorDetail)) {
            return false;
        }
        List<ApplicationStackTrace> this$stackTraces = this.getStackTraces();
        List<ApplicationStackTrace> other$stackTraces = other.getStackTraces();
        return !(this$stackTraces == null ? other$stackTraces != null : !((Object)this$stackTraces).equals(other$stackTraces));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Result;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isStatus() ? 79 : 97);
        result = result * 59 + this.getErrorCode();
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        String $errorDetail = this.getErrorDetail();
        result = result * 59 + ($errorDetail == null ? 43 : $errorDetail.hashCode());
        List<ApplicationStackTrace> $stackTraces = this.getStackTraces();
        result = result * 59 + ($stackTraces == null ? 43 : ((Object)$stackTraces).hashCode());
        return result;
    }

    public String toString() {
        return "Result(status=" + this.isStatus() + ", message=" + this.getMessage() + ", data=" + this.getData() + ", errorCode=" + this.getErrorCode() + ", errorDetail=" + this.getErrorDetail() + ", stackTraces=" + this.getStackTraces() + ")";
    }
}

