/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.cloud.core.result;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.guerlab.cloud.core.result.ApplicationStackTrace;
import net.guerlab.commons.collection.CollectionUtil;
import org.springframework.lang.Nullable;

public class RemoteException
extends RuntimeException {
    private final ApplicationStackTrace applicationStackTrace;

    private RemoteException(String message, ApplicationStackTrace applicationStackTrace, @Nullable RemoteException cause) {
        super(message, cause);
        this.applicationStackTrace = applicationStackTrace;
    }

    @Nullable
    public static RemoteException build(String message, List<ApplicationStackTrace> applicationStackTraces) {
        if (CollectionUtil.isEmpty(applicationStackTraces)) {
            return new RemoteException(message, new ApplicationStackTrace(), null);
        }
        RemoteException exception = null;
        for (int i = applicationStackTraces.size() - 1; i >= 0; --i) {
            exception = new RemoteException(message, applicationStackTraces.get(i), exception);
        }
        return exception;
    }

    private static void fillApplicationStackTrace(List<ApplicationStackTrace> list, Throwable cause) {
        if (!(cause instanceof RemoteException)) {
            return;
        }
        RemoteException e = (RemoteException)cause;
        list.add(e.applicationStackTrace);
        RemoteException.fillApplicationStackTrace(list, e.getCause());
    }

    @Override
    public StackTraceElement[] getStackTrace() {
        if (this.applicationStackTrace.getStackTrace() == null) {
            return new StackTraceElement[0];
        }
        return this.applicationStackTrace.getStackTrace().stream().map(this::buildStackTraceElement).collect(Collectors.toList()).toArray(new StackTraceElement[0]);
    }

    private StackTraceElement buildStackTraceElement(String stackTrace) {
        int lastPointIndex = stackTrace.lastIndexOf(".");
        int colonIndex = stackTrace.lastIndexOf(":");
        String declaringClass = stackTrace.substring(0, lastPointIndex);
        String methodName = stackTrace.substring(lastPointIndex + 1, colonIndex);
        int lineNumber = Integer.parseInt(stackTrace.substring(colonIndex + 1));
        return new StackTraceElement(declaringClass, methodName, "", lineNumber);
    }

    public List<ApplicationStackTrace> getApplicationStackTraces() {
        ArrayList<ApplicationStackTrace> list = new ArrayList<ApplicationStackTrace>();
        RemoteException.fillApplicationStackTrace(list, this);
        return list;
    }

    public ApplicationStackTrace getApplicationStackTrace() {
        return this.applicationStackTrace;
    }
}

